package com.yeejoin.amos.iec104.business.dao.repository;

import java.util.List;

import com.yeejoin.amos.connect.dao.entity.PointConfigVo;
import org.apache.ibatis.annotations.Update;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository("iPointConfigDao")
public interface IPointConfigDao  extends BaseDao<PointConfigVo, Long> {

	List<PointConfigVo> findAllByChannelNoAndPointType(String channelNo, String pointType);

	@Update(value="delete from PointConfigVo where channelNo=?1")
	void deleteAllByChannelNo(String channelNo);
	@Query(value="select pointClassify from PointConfigVo where channelNo=?1 group by pointClassify")
	List<String> getYcPointType(String channelNo);

	@Query(value="select new com.yeejoin.amos.connect.dao.entity.PointConfigVo(p.id, p.commonAddress, p.originatorAddress, p.pointType, p.pointClassify, p.invalid, p.channelNo, p.name, p.pointCode ) from PointConfigVo p , ConfigVo c  where p.channelNo=c.channelNo and c.serviceId=?1 and p.originatorAddress=?2 and p.pointClassify=?3")
	PointConfigVo findOneByServicesIdAndInfoAddress(String serviceId, int address, String pointType);

	PointConfigVo findOneByPointCode(String pointCode);
}
