package com.yeejoin.amos.iec104.business.dao.repository;

import java.util.List;

import com.yeejoin.amos.connect.dao.entity.ConfigVo;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository("iServiceConfDao")
public interface IServiceConfDao extends BaseDao<ConfigVo, Long>{

	List<ConfigVo> findAllByServiceType(String serviceType);

	ConfigVo findOneByServiceTypeAndPort(String serviceType, String port);

	ConfigVo findOneByServiceTypeAndServiceId(String serviceType, String serverId);

	@Query(value="select max(id) from ConfigVo")
	String findMaxId();

	ConfigVo findOneByServiceId(String serviceId);

}
