package com.yeejoin.amos.iec104.business.service.impl;

import java.util.List;

import com.yeejoin.amos.connect.dao.entity.ConfigVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.iec104.business.dao.repository.IServiceConfDao;
import com.yeejoin.amos.iec104.business.service.intfc.IConfService;

@Service
public class ConfServiceImpl implements IConfService {

    @Autowired
    private IServiceConfDao iServiceConfDao;
	
	@Override
	public void add(ConfigVo vo) {
		iServiceConfDao.save(vo);
	}

	@Override
	public void delete(Long id) {
		iServiceConfDao.delete(id);
	}

	@Override
	public List<ConfigVo> getServerByType(String type) {
		return iServiceConfDao.findAllByServiceType(type);
	}

	@Override
	public void updateServer(ConfigVo vo) {
		iServiceConfDao.save(vo);
	}

	@Override
	public ConfigVo getServerByPort(String port) {
		return iServiceConfDao.findOneByServiceTypeAndPort("IEC_CLIENT",port);
	}

	@Override
	public ConfigVo getServerByTypeAndServiceId(String type, String serverId) {
		return iServiceConfDao.findOneByServiceTypeAndServiceId(type,serverId);
	}

	@Override
	public String getMaxNo() {
		return iServiceConfDao.findMaxId();
	}

	@Override
	public ConfigVo getServerByServiceId(String serviceId) {
		return iServiceConfDao.findOneByServiceId(serviceId);
	}

	@Override
	public ConfigVo getServerById(Long id) {
		return iServiceConfDao.findOne(id);
	}

	@Override
	public ConfigVo findById(Long id) {
		return iServiceConfDao.findOne(id);
	}

	@Override
	public ConfigVo getServerByChannleNoId(String channelNo) {
		// TODO Auto-generated method stub
		return null;
	}

}
