package com.yeejoin.amos.iec104.business.service.impl;

import java.util.HashMap;
import java.util.List;

import javax.annotation.PostConstruct;

import com.yeejoin.amos.connect.dao.entity.PointConfigVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.iec104.business.dao.repository.IPointConfigDao;
import com.yeejoin.amos.iec104.business.service.intfc.IPointConfigService;

@Service
public class PointConfigServiceImpl implements IPointConfigService{
	
    @Autowired
    private IPointConfigDao iPointConfigDao;
	@Autowired
	private RedisTemplate redisTemplate;
//	@Override
//	public List<PointConfigVo> getAllPointData(String channelNo) {
//		return iPointConfigDao.findAllByChannelNo(channelNo);
//	}

	@Override
	public List<PointConfigVo> getAllYXPointData(String channelNo) {
		return iPointConfigDao.findAllByChannelNoAndPointType(channelNo, "yx");
	}

	@Override
	public List<PointConfigVo> getAllYCPointData(String channelNo) {
		return iPointConfigDao.findAllByChannelNoAndPointType(channelNo, "yc");
	}

	@Override
	@Transactional
	public void save(List<PointConfigVo> list) {
		iPointConfigDao.save(list);
	}

	@Override
	@Transactional
	public void deleteByChannelNo(String channelNo) {
		iPointConfigDao.deleteAllByChannelNo(channelNo);
	}

	@Override
	public List<String> getYcPointType(String channelNo) {
		return iPointConfigDao.getYcPointType(channelNo);
	}

	@Override
	public PointConfigVo findByServicesIdAndInfoAddress(String serviceId, int address) {
		String pointType = "";
		if (address < 0x4000) {
			pointType = "yx";
		} else {
			pointType = "yc";
			address = address - 0x4000;
		}
		Pageable pageable = new PageRequest(0, 1);
		return findPointfromRedis(serviceId+pointType+address);
//		return iPointConfigDao.findOneByServicesIdAndInfoAddress(serviceId, address, pointType);
	}
	
	@Override
	@PostConstruct
	public void loadRedisData() {
		HashMap<String, PointConfigVo> map = new HashMap<String, PointConfigVo>();
		long count = iPointConfigDao.count();
		for (int i = 0; i < (count/100000 + 1); i++) {
			//分页信息
	        Pageable pageable = new PageRequest(i, 100000*(i+1)); 
			iPointConfigDao.findAll().stream().forEach((PointConfigVo v) -> {
				map.put(v.getChannelNo().replace("N", "S") + v.getPointType() +v.getOriginatorAddress(), v);
			});
			redisTemplate.opsForHash().putAll("pointConfig", map);
		}
	}

	
	@Override
	public PointConfigVo findPointfromRedis(String key) {
		return (PointConfigVo) redisTemplate.opsForHash().get("pointConfig", key);
	}

	@Override
	public PointConfigVo findPointByPointCode(String pointCode) {
		return iPointConfigDao.findOneByPointCode(pointCode);
	}

	@Override
	public void updatePoint(PointConfigVo vo) {
		String key = vo.getChannelNo().replace("N", "S") + vo.getPointType() +vo.getOriginatorAddress();
		redisTemplate.opsForHash().put("pointConfig", key, vo);
		iPointConfigDao.save(vo);
	}
}
