/**
 * 
 */
package com.yeejoin.amos.iec104.context;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;

import com.yeejoin.amos.iec104.business.constants.IEC104Constant;

/**
 * iot-spring上下文
 * 
 * @author as-youjun
 *
 */
public class FireAutoIntfContext {

	/**
	 * 实例
	 */
	private static FireAutoIntfContext instance;

	/**
	 * spring上下文
	 */
	private ApplicationContext applicationContext;

	/**
	 * 构造方法
	 */
	private FireAutoIntfContext() {
		Logger.getLogger(this.getClass()).debug(IEC104Constant.CONSTRUCTOR);
	}

	/**
	 * 获取单例
	 * 
	 * @return
	 */
	public static synchronized FireAutoIntfContext getInstance() {
		if (instance == null) {
			instance = new FireAutoIntfContext();
		}
		return instance;
	}

	/**
	 * 设置上下文
	 * 
	 * @param applicationContext
	 */
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	/**
	 * 获取上下文
	 * 
	 * @param beanName
	 * @return
	 */
	public Object getBean(String beanName) {
		return applicationContext.getBean(beanName);
	}

	/**
	 * 获取上下文
	 * 
	 * @param requiredType
	 * @return
	 */
	public Object getBean(Class<?> requiredType) {
		return applicationContext.getBean(requiredType);
	}

}
