package com.yeejoin.amos.iec104.context;

import javax.annotation.PostConstruct;

import org.springframework.stereotype.Component;

import com.yeejoin.amos.iec104.core.util.DateUtil;
import com.yeejoin.amos.op.core.entity.BusinessEntity;
import com.yeejoin.amos.op.core.entity.handler.EntityHandler;
import com.yeejoin.amos.op.core.entity.handler.EntityListener;
import com.yeejoin.amos.security.context.CurrentAuthentication;


/**
 * 
 * <pre>
 * 实体变化
 * </pre>
 *
 * @author as-chenjiajun
 * @version $Id: FireAutoIntfEntityHandler.java, v 0.1 2018年5月29日 下午3:42:41 as-chenjiajun Exp $
 */
@Component
public class FireAutoIntfEntityHandler extends EntityHandler
{
	@PostConstruct
	private void init()
	{
		EntityListener.addModelHandler(this);
	}
	
	public void prePersist(BusinessEntity model)
	{
		model.setCreateUser(CurrentAuthentication.getAuthenticatedUserId());
		model.setCreateDate(DateUtil.getCurrentDate());	
	}

	public void preUpdate(BusinessEntity model)
	{
		model.setUpdateUser(CurrentAuthentication.getAuthenticatedUserId());	
		model.setUpdateDate(DateUtil.getCurrentDate());
	}
}
