package com.yeejoin.amos.iec104.core.common.datastructure;

import java.util.List;

/**
 * 
 * <pre>
 * 树节点
 * </pre>
 *
 * @author as-chenjiajun
 * @version $Id: TreeNode.java, v 0.1 2018年3月8日 下午5:36:46 as-chenjiajun Exp $
 */
public class TreeNode
{
	//数据库数据ID
	private Long sourceId;
	
	//界面key
	private String key;

	//界面父节点key
	private String parentKey;

	//显示名称
	private String title;

	//子节点
	private List<TreeNode> children;
	
	//值
	private String value;

	public TreeNode(String key, String title, String parentKey)
	{
		this.key = key;
		this.title = title;
		this.parentKey = parentKey;
		this.value = title;
	}

	public TreeNode(String key, String title, TreeNode parent)
	{
		this.key = key;
		this.title = title;
		this.parentKey = parent.getParentKey();
		this.value = title;
	}

	public String getKey()
	{
		return key;
	}

	public void setKey(String key)
	{
		this.key = key;
	}

	public String getParentKey()
	{
		return parentKey;
	}

	public void setParentKey(String parentKey)
	{
		this.parentKey = parentKey;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public List<TreeNode> getChildren()
	{
		return children;
	}

	public void setChildren(List<TreeNode> children)
	{
		this.children = children;
	}

	public Long getSourceId()
	{
		return sourceId;
	}

	public void setSourceId(Long sourceId)
	{
		this.sourceId = sourceId;
	}

	public String getValue()
	{
		return value;
	}

	public void setValue(String value)
	{
		this.value = value;
	}
	
}
