package com.yeejoin.amos.iec104.core.listener;

import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
/**
 * 
 * <pre>
 * 配置信息获取
 * </pre>
 *
 * @author as-chenjiajun
 * @version $Id: PortConfigListener.java, v 0.1 2018年3月14日 下午3:10:15 as-chenjiajun Exp $
 */
@Component
public class PortConfigListener implements ApplicationListener<EmbeddedServletContainerInitializedEvent>
{
	/**
	 * 服务器端口号
	 */
	private int serverPort;
	
	@Override
	public void onApplicationEvent(
			EmbeddedServletContainerInitializedEvent event)
	{
		this.serverPort = event.getEmbeddedServletContainer().getPort();
	}

	public int getServerPort()
	{
		return serverPort;
	}

}
