package com.yeejoin.amos.iec104.core.threadpool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.log4j.Logger;

import com.yeejoin.amos.iec104.business.constants.IEC104Constant;

/**
 * 线程池
 */
public class AmosThreadPool {

    /**
     * 日志记录器
     */
    private static final Logger logger = Logger
            .getLogger(AmosThreadPool.class);

    /**
     * 单例
     */
    private static AmosThreadPool instance;

    /**
     * 执行服务
     */
    private static ExecutorService executorService;

    /**
     * 获取单例
     *
     * @return
     */
    public static AmosThreadPool getInstance() {
        if (instance == null) {
            synchronized (AmosThreadPool.class) {
                if (instance == null) {
                    instance = new AmosThreadPool();
                }
            }
        }
        return instance;
    }

    static {
        executorService = Executors
                .newFixedThreadPool(IEC104Constant.AMOS_THREAD_NUM);
    }

    /**
     * 执行线程
     *
     * @param task
     */
    public void execute(Runnable task) {
        executorService.execute(task);
    }

}
