package com.yeejoin.amos.iec104.core.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * 
 * <pre>
 * 日期
 * </pre>
 *
 * @author as-chenjiajun
 * @version $Id: DateUtil.java, v 0.1 2018年1月29日 下午5:08:40 as-chenjiajun Exp $
 */
public class DateUtil
{
	private static String LONG_PATTERN = "yyyy-MM-dd HH:mm:ss";
	private static String MID_PATTERN = "yyyy-MM-dd HH:mm";
	private static String SHORT_PATTERN = "yyyy-MM-dd";

	public static long THREE_DAY_MILLSEC = 259200000L;
	public static long ONE_DAY_MILLSEC = 86400000L;
	public static long ONE_HOUR_MILLSEC = 3600000L;
	public static long THREE_HOURS_MILLSEC = 10800000L;
	public static long TWELVE_HOURS_MILLSEC = 43200000L;
	

	public static Date EMPTY_DATE = null;
	static
	{
		Calendar calendar = Calendar.getInstance();
		calendar.set(9999, 0, 0);
		EMPTY_DATE = calendar.getTime();
	}

	/**
	 * 
	 * <pre>
	 * 获取当前北京时间
	 * </pre>
	 *
	 * @return
	 */
	public static Date getCurrentDate()
	{
		return getCurrentCalendar().getTime();
	}

	public static String getLongCurrentDate()
	{
		return new SimpleDateFormat(LONG_PATTERN)
				.format(getCurrentCalendar().getTime());
	}

	public static String getLongDate(Date date)
	{
		if (null == date)
			return getLongCurrentDate();
		else
			return new SimpleDateFormat(LONG_PATTERN).format(date);
	}

	public static String getLongDate(long value)
	{
		return new SimpleDateFormat(LONG_PATTERN).format(new Date(value));
	}

	public static String getShortCurrentDate()
	{
		return new SimpleDateFormat(SHORT_PATTERN).format(new Date());
	}

	public static String getShortDate(Date date)
	{
		if (null == date)
			return getShortCurrentDate();
		else
			return new SimpleDateFormat(SHORT_PATTERN).format(date);
	}

	public static String getShortDate(long value)
	{
		return new SimpleDateFormat(SHORT_PATTERN).format(new Date(value));
	}

	public static Date getShortCurrentDate(String shortDateStr) throws ParseException
	{
		return new SimpleDateFormat(SHORT_PATTERN).parse(shortDateStr);
	}

	public static Date getLongDate(String longDateStr) throws ParseException
	{
		return new SimpleDateFormat(LONG_PATTERN).parse(longDateStr);
	}

	public static String getMidCurrentDate()
	{
		return new SimpleDateFormat(MID_PATTERN).format(new Date());
	}

	public static String getMidDate(Date date)
	{
		if (null == date)
			return getMidCurrentDate();
		else
			return new SimpleDateFormat(MID_PATTERN).format(new Date());
	}

	public static String getMidDate(long value)
	{
		return new SimpleDateFormat(MID_PATTERN).format(new Date(value));
	}

	public static Date str2Date(String strDate, String dateFormat)
	{
		SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(strDate, pos);
		return strtodate;
	}
	
	public static int getYear(Date date)
	{
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int year = calendar.get(Calendar.YEAR);
		return year;
	}

	public static int getMonth(Date date)
	{
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int month = calendar.get(Calendar.MONTH) + 1;
		return month;
	}

	public static int getDay(Date date)
	{
		Calendar c = Calendar.getInstance();
		c.setTime(date);
		int day = c.get(Calendar.DATE);
		return day;
	}

	public static int getHour(Date date)
	{

		Calendar c = Calendar.getInstance();
		c.setTime(date);
		int hour = c.get(Calendar.HOUR_OF_DAY);
		return hour;
	}

	public static int getMinite(Date date)
	{
		Calendar c = Calendar.getInstance();
		c.setTime(date);
		int minite = c.get(Calendar.MINUTE);
		return minite;
	}

	/**
	 * 
	 * <pre>
	 * 获取当前北京时间
	 * </pre>
	 *
	 * @return
	 */
	public static Calendar getCurrentCalendar()
	{
		TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
		return Calendar.getInstance();
	}
	
	/**
	 * 
	 * <pre>
	 * 获取当前两个时间差
	 * </pre>
	 *
	 * @return
	 */
	public static String getTimeDifference(Date dateBefore, Date dateAfter )
	{
		long l=dateAfter.getTime()-dateBefore.getTime();
		long day=l/(24*60*60*1000);
		long hour=(l/(60*60*1000)-day*24);
		long min=((l/(60*1000))-day*24*60-hour*60);
		long s=(l/1000-day*24*60*60-hour*60*60-min*60);
		return ""+day+"天"+hour+"小时"+min+"分"+s+"秒";
	}
}
