package com.yeejoin.amos.iec104.tcp.client;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.yeejoin.amos.connect.dao.entity.ConfigVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import com.yeejoin.amos.iec104.business.dao.repository.IServiceConfDao;

@Component
@Scope("singleton")
public class IEC104ClientManager {
	
	private static ConcurrentHashMap<String, IEC104Client> servers = new ConcurrentHashMap<String, IEC104Client>();
	
    public static boolean isDebug = false;
    
    @Autowired
    private IServiceConfDao iServiceConfDao;
    
	public void init() {
		List<ConfigVo> list = iServiceConfDao.findAllByServiceType("IEC_SERVER");
		for (ConfigVo vo : list) {
			if (!ObjectUtils.isEmpty(vo.getIp())) {
				IEC104Client iec104Client = new IEC104Client(vo.getIp(), Integer.parseInt(vo.getPort()));
				iec104Client.setCommonAddress(vo.getCommonAddress());
				try {
					iec104Client.setClientId(vo.getServiceId());
					iec104Client.init(vo.getServiceId());
					
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				servers.put(vo.getIp()+":" +vo.getPort(), iec104Client);
			}
		}
		
	}
	
	public void createClient(String ip, String port, String commonAddress) {
		if (ObjectUtils.isEmpty(port)) {
			port = "2404";
		}
		
		if (!ObjectUtils.isEmpty(ip) && !ObjectUtils.isEmpty(port)) {
			if (servers.contains(ip+":"+port)) {
				
				return;
			}
			IEC104Client iec104Client = new IEC104Client(ip, Integer.parseInt(port));
			iec104Client.setCommonAddress(commonAddress);
			try {
				iec104Client.init(commonAddress);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			servers.put(ip+":"+port, iec104Client);
		}
	}
	
	public void closeClient(String ip, String port) {
		IEC104Client client = servers.get(ip+":"+port);
		client.close();
		servers.remove(ip+":"+port);
	}
	
	public void removeClientByIp(String ip) {
		servers.remove(ip);
	}
	
	/**
	 * 根据IP获取同服务器的连接
	 * @param ip
	 * @return
	 */
	public IEC104Client getServerByIp(String ip) {
		return servers.get(ip);
	}
	
	/**
	 * 向指定ip的服务端发送数据
	 * @param ip
	 * @param strBytes
	 */
//	public void sendMessageToServer(String ip, String strBytes) {
//		IEC104Client server = servers.get(ip);
//		if (!ObjectUtils.isEmpty(server) && server.isConnected()) {
//			server.sendMessage(strBytes);
//		} else {
//			throw new YeeException("没有获取到服务");
//		}
//	}
	
	/**
	 * 广播发送数据
	 * @param strBytes
	 */
//	public void broadcastMessage(String strBytes) {
//		for (IEC104Client client : servers.values()) {
//			if (client.isConnected()) {
//				client.sendMessage(strBytes);
//			}
//		}
//	}
	
	/**
	 * 获取所有连接的客户端
	 * @return
	 */
	public ConcurrentHashMap<String, IEC104Client> getServers() {
		return servers;
	}
	
	public Collection<IEC104Client> getClients() {
		return servers.values();
	}
}
