package com.yeejoin.amos.iec104.tcp.entity;

import java.io.IOException;

import io.netty.buffer.ByteBuf;
import net.sf.json.JSONObject;

/**
 * 品质描述
 */
abstract class IeAbstractQuality extends InformationElement {

    protected int value;

    public IeAbstractQuality(boolean blocked, boolean substituted, boolean notTopical, boolean invalid) {

        value = 0;

        if (blocked) {
            value |= 0x10;
        }
        if (substituted) {
            value |= 0x20;
        }
        if (notTopical) {
            value |= 0x40;
        }
        if (invalid) {
            value |= 0x80;
        }

    }

    public IeAbstractQuality(ByteBuf is) throws IOException {
        value = (is.readByte() & 0xff);
    }

    @Override
    public int encode(byte[] buffer, int i) {
        buffer[i] = (byte) value;
        return 1;
    }

    public boolean isBlocked() {
        return (value & 0x10) == 0x10;
    }

    public boolean isSubstituted() {
        return (value & 0x20) == 0x20;
    }

    public boolean isNotTopical() {
        return (value & 0x40) == 0x40;
    }

    public boolean isInvalid() {
        return (value & 0x80) == 0x80;
    }

    @Override
    public String toString() {
        return "被封锁: " + isBlocked() + ", 被取代: " + isSubstituted() + ", 非当前值: " + isNotTopical()
                + ", 是否有效: " + isInvalid();
    }
    
    public JSONObject toJson() {
    	JSONObject json = new JSONObject();
    	json.put("isBlocked", isBlocked());
    	json.put("isSubstituted", isSubstituted());
    	json.put("isNotTopical", isNotTopical());
    	json.put("isInvalid", isInvalid());
    	return json;
    }
}
