package com.yeejoin.amos.iec104.tcp.entity;

import java.io.IOException;

import io.netty.buffer.ByteBuf;
import net.sf.json.JSONObject;

/**
 * 品质描述
 * 
 */
public class IeQuality extends IeAbstractQuality {

    public IeQuality(boolean overflow, boolean blocked, boolean substituted, boolean notTopical, boolean invalid) {
        super(blocked, substituted, notTopical, invalid);

        if (overflow) {
            value |= 0x01;
        }
    }

    IeQuality(ByteBuf is) throws IOException {
        super(is);
    }

    public boolean isOverflow() {
        return (value & 0x01) == 0x01;
    }

    @Override
    public String toString() {
        return "品质描述, 溢出: " + isOverflow() + ", " + super.toString();
    }
    
    public JSONObject toJson() {
    	JSONObject json = super.toJson();
    	json.put("isOverflow", isOverflow());
    	return json;
    }
}
