package com.yeejoin.amos.iec104.tcp.entity;

import java.io.IOException;

import io.netty.buffer.ByteBuf;
import net.sf.json.JSONObject;

/**
 * 单点信息
 * 
 */
public class IeSinglePointWithQuality extends IeAbstractQuality {

    public IeSinglePointWithQuality(boolean on, boolean blocked, boolean substituted, boolean notTopical,
            boolean invalid) {
        super(blocked, substituted, notTopical, invalid);

        if (on) {
            value |= 0x01;
        }
    }

    public IeSinglePointWithQuality(ByteBuf is) throws IOException {
        super(is);
    }

    public boolean isOn() {
        return (value & 0x01) == 0x01;
    }

    @Override
    public String toString() {
        return "单点, 是否开闸: " + isOn() + ", " + super.toString();
    }
    
    public JSONObject toJson() {
    	JSONObject json = super.toJson();
    	json.put("isOn", isOn());
    	return json;
    }
}
