package com.yeejoin.amos.iec104.tcp.server;

import java.net.InetSocketAddress;

import org.apache.log4j.Logger;

import com.yeejoin.amos.iec104.tcp.IEC104Decoder;
import com.yeejoin.amos.iec104.tcp.IEC104Encoder;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;


public class IEC104ChannelInitalizer extends ChannelInitializer<SocketChannel>{
	private String serviceId;
	
	public IEC104ChannelInitalizer(String serviceId) {
		this.serviceId = serviceId;
	}
	
    @Override
    protected void initChannel(SocketChannel channel) throws Exception {
        InetSocketAddress s = channel.remoteAddress();
        Logger.getLogger(this.getClass()).debug("client channel:" + s.toString());
        // 空闲状态助手
//		channel.pipeline().addLast(new IdleStateHandler(15, 40, 60, TimeUnit.SECONDS));
        // 104报文解码器
        channel.pipeline().addLast(new IEC104Decoder(serviceId));
        // 104apdu处理类
        channel.pipeline().addLast(new IEC104ServerHandler());
        // 104编码发送处理类
        channel.pipeline().addLast(new IEC104Encoder(serviceId));
    }
}
