package com.yeejoin.amos.iec104.tcp.utils;


import com.yeejoin.amos.iec104.tcp.entity.IeShortFloat;


public class ChangeUtils {
    private static final char[] HEX_CHAR_TABLE = {
            '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
    };

    public static String toHexString(Byte[] data){
        byte[] resultBytes = new byte[data.length];
        for(int i =0 ;i<data.length;i++){
            resultBytes[i] = data[i];
        }
        return toHexString(resultBytes);
    }

    public static String toHexString(byte[] data){
        if(data == null || data.length == 0)
            return null;
        byte[] hex = new byte[data.length * 2];
        int index = 0;
        for(byte b : data){
            int v = b & 0xFF;
            hex[index++] = (byte) HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = (byte) HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    public static byte[] hexStringToBytes(String data){
        if(data == null || "".equals(data))
            return null;
        data = data.toUpperCase();
        int length = data.length()/2;
        char[] dataChars = data.toCharArray();
        byte[] byteData = new byte[length];
        for (int i = 0;i<length;i++){
            int pos = i * 2;
            byteData[i] = (byte)(charToByte(dataChars[pos]) << 4 | charToByte(dataChars[pos + 1]));
        }
        return byteData;
    }

    public static byte charToByte(char c){
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byteAppend(byte[] bytes){
        StringBuffer stringBuffer = new StringBuffer();
        for (int i=bytes.length-1;i>=0;i--){
            stringBuffer.append(String.format("%02d",bytes[i]));
        }
        return stringBuffer.toString();
    }

    public static String floatToHexstr(float value){
        byte[] buffer = new byte[4];
        new IeShortFloat(value).encode(buffer,0);
        return toHexString(buffer);
    }

    public static String encode(float value){
        int tempVal = Float.floatToIntBits(value);
        byte[] buffer = new byte[4];
        buffer[0] = (byte) tempVal;
        buffer[1] = (byte) (tempVal >> 8);
        buffer[2] = (byte) (tempVal >> 16);
        buffer[3] = (byte) (tempVal >> 24);
        int[] s = new int[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; i++){
            s[i] = (buffer[i] & 0xff);
            if (Integer.toHexString(s[i]).length() == 1){
                sb.append("0" + Integer.toHexString(s[i]) + " ");
            }else {
                sb.append(Integer.toHexString(s[i]) + " ");
            }
        }
        return sb.toString().toUpperCase();
    }

    public static String encodeInfomationAddress(int address) {
        byte[] buffer = new byte[3];
        buffer[0] = (byte) address;
        buffer[1] = (byte) (address >> 8);
        buffer[2] = (byte) (address >> 16);

        int[] s = new int[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; i++){
            s[i] = (buffer[i] & 0xff);
            if (Integer.toHexString(s[i]).length() == 1){
                sb.append("0" + Integer.toHexString(s[i]) + " ");
            }else {
                sb.append(Integer.toHexString(s[i]) + " ");
            }
        }
        return sb.toString().toUpperCase();
    }

    public static String encodeCommonAddress(int address) {
        byte[] buffer = new byte[2];
        buffer[0] = (byte) address;
        buffer[1] = (byte) (address >> 8);
        int[] s = new int[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; i++){
            s[i] = (buffer[i] & 0xff);
            if (Integer.toHexString(s[i]).length() == 1){
                sb.append("0" + Integer.toHexString(s[i]) + " ");
            }else {
                sb.append(Integer.toHexString(s[i]) + " ");
            }
        }
        return sb.toString().toUpperCase();
    }
    
    public static String encode(int num) {
        byte[] buffer = new byte[2];
        buffer[0] = (byte) num;
        buffer[1] = (byte) (num >> 8);
        int[] s = new int[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; i++){
            s[i] = (buffer[i] & 0xff);
            if (Integer.toHexString(s[i]).length() == 1){
                sb.append("0" + Integer.toHexString(s[i]) + " ");
            }else {
                sb.append(Integer.toHexString(s[i]) + " ");
            }
        }
        return sb.toString().toUpperCase();
    }
    
    public static byte[] float2byte(float f) {
		
		// 把float转换为byte[]
		int fbit = Float.floatToIntBits(f);
		
		byte[] b = new byte[4];  
	    for (int i = 0; i < 4; i++) {  
	        b[i] = (byte) (fbit >> (24 - i * 8));  
	    } 
	    
	    // 翻转数组
		int len = b.length;
		// 建立一个与源数组元素类型相同的数组
		byte[] dest = new byte[len];
		// 为了防止修改源数组，将源数组拷贝一份副本
		System.arraycopy(b, 0, dest, 0, len);
		byte temp;
		// 将顺位第i个与倒数第i个交换
		for (int i = 0; i < len / 2; ++i) {
			temp = dest[i];
			dest[i] = dest[len - i - 1];
			dest[len - i - 1] = temp;
		}
	    
	    return dest;
	    
	}

}
