package com.yeejoin.amos.iec104.websocket;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import org.springframework.stereotype.Component;

@ServerEndpoint(value = "/equipmentWebsocket")
@Component
public class EquipmentWebsocket {
    //静态变量，用来记录当前在线连接数。应该把它设计成线程安全的。
    private static int onlineCount = 0;
    //与某个客户端的连接会话，需要通过它来给客户端发送数据
    private static ConcurrentHashMap<String, Session> clients = new ConcurrentHashMap<String, Session>();
    /**
     * 	连接建立成功调用的方法
     * */
    @OnOpen
    public void onOpen(Session session) {
        clients.put(session.getId(), session);
        addOnlineCount();           //在线数加1
        System.out.println("有新连接加入！当前在线人数为" + getOnlineCount());
    }

    /**
     * 	连接关闭调用的方法
     */
    @OnClose
    public void onClose(Session session) {
    	if(clients.values().contains(session)) {
    		clients.values().remove(session);
    		return;
    	}
        subOnlineCount();           //在线数减1
        System.out.println("有一连接关闭！当前在线人数为" + getOnlineCount());
    }

    /**
     * 	收到客户端消息后调用的方法
     *
     * @param message 客户端发送过来的消息*/
    @OnMessage
    public void onMessage(String message, Session session) {
        System.out.println("来自客户端的注册消息:" + message);
    }
    
    @OnError
    public void onError(Session session, Throwable error) {
        System.out.println("发生错误");
        error.printStackTrace();
    }
    
    /**
     * 	群发自定义消息
     * */
    public static void sendInfo(String message) throws IOException {
    	for (Session websocket : clients.values()) {
    		try {
    			websocket.getBasicRemote().sendText(message);
			} catch (Exception e) {
				 continue;
			}
    	}
    }
    

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        EquipmentWebsocket.onlineCount++;
    }

    public static synchronized void subOnlineCount() {
        EquipmentWebsocket.onlineCount--;
    }
}
