package com.yeejoin.amos.uart.business.service.intfc;

import com.yeejoin.amos.connect.dao.entity.UartVo;

import java.util.List;

/**
 * 串口服务接口
 */
public interface UartService {
    /**
     * 保存串口配置
     * @param vo
     */
    public void saveUart(UartVo vo);

    /**
     * 通过Id查询串口信息
     * @param id
     * @return
     */
    public UartVo findById(Long id);

    /**
     * 查询所有串口信息
     * @return
     */
    public List<UartVo> findAll();

    /**
     * 查询串口
     * @param ids
     */
    public void delete(Long ids);

    /**
     * 给指定串口发送数据
     * @param comPort
     * @param message
     */
    public void sendData(String comPort, String message);

    /**
     * 获取操作系统所有的串口
     * @return
     */
    public List<String> findAllSystemSerialPort();

    /**
     * 传输文件
     * @param serialPort
     * @param bytes
     */
    void sendBytes(String serialPort, byte[] bytes);
}
