package com.yeejoin.amos.uart.rxtx.reader;


import com.yeejoin.amos.uart.rxtx.SerialContext;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

/**
 * @author han xinjian
 **/
public class AnyDataReader implements SerialReader {

    SerialContext serialContext;

    public AnyDataReader(SerialContext serialContext) {
        this.serialContext = serialContext;
    }

    @Override
    public byte[] readBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        try {
            int read = serialContext.getSerialPort().getInputStream().read();
            while (read != -1) {
                byteBuffer.put(((byte) read));
                read = serialContext.getSerialPort().getInputStream().read();
            }
            return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}
