package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  @author gaojianqiang
 */

public enum PlanReplyMessageEnum {
    FIRE_PERSON("文本","text"),
    OPS_PERSON("图片","image"),
    REAL_PERSON("视频","video");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;


    private PlanReplyMessageEnum(String name, String code){
        this.name = name;
        this.code = code;
    }

    public static PlanReplyMessageEnum getEnum(String code) {
        PlanReplyMessageEnum checkStatusEnum = null;
        for(PlanReplyMessageEnum type: PlanReplyMessageEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }

        return checkStatusEnum;
    }

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String,Object>> nameList = new ArrayList<>();
        for (PlanReplyMessageEnum c: PlanReplyMessageEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("name", c.getName());
            map.put("code", c.getCode());
            nameList.add(map);
        }
        return nameList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

