package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.PlanOperationRecordMapper;
import com.yeejoin.amos.fas.business.dao.repository.IPlanRuleDao;
import com.yeejoin.amos.fas.business.service.intfc.IPlanRuleService;
import com.yeejoin.amos.fas.dao.entity.PlanRule;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

@Service
public class PlanRuleServiceImpl implements IPlanRuleService {

    @Autowired
    private IPlanRuleDao planRuleDao;

    @Autowired
    private PlanOperationRecordMapper planOperationRecordMapper;

    @Value("classpath:/json/plan-step.json")
    private Resource planStepResource;

    @Override
    public void updatePlanRuleByBatchNo(String batchNo) {
        try {
            // 根据批次号查询预案步骤
            PlanRule planRule = planOperationRecordMapper.getPlanRuleByBatchNo(batchNo);
            String json = IOUtils.toString(planStepResource.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
            planRule.setPlanStep(json);
            planRuleDao.save(planRule);
        } catch (IOException e) {
            throw new RuntimeException("初始化预案规则planStep数据失败！");
        }
    }
}
