package com.yeejoin.amos.fas.business.dao.mapper;

import com.google.gson.JsonObject;
import com.yeejoin.amos.fas.dao.entity.PlanRule;
import com.yeejoin.amos.fas.datasync.bo.PlanOperationRecordSyncBo;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/1/15 10:53
 */
@Repository
public interface PlanOperationRecordMapper {

    int filterCount(Map<String, Object> params);

    List<Map<String, Object>> filterList(Map<String, Object> params);

    List<PlanOperationRecordSyncBo> getPlanOperationRecordSyncBoList(Map<String, Object> map);

    /**
     * 根据批次号查询预案步骤
     * @param batchNo 批次号
     * @return 步骤
     */
    String getPlanStepByBatchNo(String batchNo);

    /**
     * 获取batchNo
     * @return
     */
    String getNewestBatchNo();
    
    /**
     * 获取batchNo
     * @return
     */
    String getLastBatchNo();

    Map<String, Object> getLatestFireEquipId();

    PlanRule getPlanRuleByBatchNo(String batchNo);
}
