package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.rule.config.ClazzUtils;
import com.yeejoin.amos.fas.business.action.CustomerAction;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.dao.mapper.*;
import com.yeejoin.amos.fas.business.dao.repository.*;
import com.yeejoin.amos.fas.business.param.AlarmParam;
import com.yeejoin.amos.fas.business.service.intfc.*;
import com.yeejoin.amos.fas.business.util.TreeUtil;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.common.enums.ContingencyPlanStatusEnum;
import com.yeejoin.amos.fas.common.enums.EquipmentRiskTypeEnum;
import com.yeejoin.amos.fas.common.enums.ExecutionTypeEnum;
import com.yeejoin.amos.fas.common.enums.PlanRecordStatusEnum;
import com.yeejoin.amos.fas.core.enums.NumberEnum;
import com.yeejoin.amos.fas.core.enums.ReserveEnum;
import com.yeejoin.amos.fas.core.util.DateUtil;
import com.yeejoin.amos.fas.dao.entity.*;
import com.yeejoin.amos.fas.datasync.bo.PlanDetailSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanOperationRecordSyncBo;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @program: YeeAmosFireAutoSysRoot
 * @description: 预案实现类
 * @author: wujunkai
 * @create: 2021-01-14 14:59
 */
@Service
public class ContingencyPlanServiceImpl implements IContingencyPlanService {

    private final Logger logger = LogManager.getLogger(ContingencyPlanServiceImpl.class);
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private IPlanOperationRecordDao planOperationRecordDao;
    @Autowired
    private IEquipmentFireEquipmentDao equipmentFireEquipmentDao;
    @Autowired
    private EquipmentSpecificMapper equipmentSpecificMapper;
    @Autowired
    private WarehouseStructureMapper warehouseStructureMapper;
    @Autowired
    private IEquipmentHandlerService equipmentHandlerService;
    @Autowired
    private IContingencyPlanInstanceRepository repository;
    @Autowired
    private IPlanVisual3dService planVisual3dService;
    @Autowired
    private IPlanStepService planStepService;
    @Qualifier("contingencyAction")
    @Autowired
    private CustomerAction customerAction;

    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Value("${station.name}")
    private String stationName;

    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${systemctl.sync.switch}")
    private Boolean dataSyncSwitch;

    @Autowired
    private IDataSyncService dataSyncService;
    private final PlanOperationRecordMapper planOperationRecordMapper;
    private final IPlanDetailDao planDetailDao;
    private final IPlanDocDao planDocDao;
    private final IPlanEquipmentDao planEquipmentDao;
    private final IPlanRuleDao planRuleDao;
    private final IPlanClassifyTreeDao classifyTreeDao;
    private final PlanDetailMapper planDetailMapper;
    private final PlanEquipmentMapper planEquipmentMapper;
    private final PlanRuleMapper planRuleMapper;
    private final PlanDocMapper planDocMapper;
    private final EmqKeeper emqKeeper;
    private final IPlanClassifyTreeService planClassifyTreeService;
    @Autowired
    IContingencyInstance iContingencyInstance;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;


    @Autowired
    public ContingencyPlanServiceImpl(IPlanDetailDao planDetailDao, IPlanDocDao planDocDao, IPlanEquipmentDao planEquipmentDao,
                                      IPlanRuleDao planRuleDao, IPlanClassifyTreeDao classifyTreeDao, PlanDetailMapper planDetailMapper,
                                      PlanEquipmentMapper planEquipmentMapper, PlanRuleMapper planRuleMapper, PlanDocMapper planDocMapper,
                                      PlanOperationRecordMapper planOperationRecordMapper, IPlanClassifyTreeService planClassifyTreeService,
                                      EmqKeeper emqKeeper) {
        this.planDetailDao = planDetailDao;
        this.planDocDao = planDocDao;
        this.planEquipmentDao = planEquipmentDao;
        this.planRuleDao = planRuleDao;
        this.classifyTreeDao = classifyTreeDao;
        this.planDetailMapper = planDetailMapper;
        this.planEquipmentMapper = planEquipmentMapper;
        this.planRuleMapper = planRuleMapper;
        this.planDocMapper = planDocMapper;
        this.planOperationRecordMapper = planOperationRecordMapper;
        this.planClassifyTreeService = planClassifyTreeService;
        this.emqKeeper = emqKeeper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContingencyPlanResponseVo planStart(ContingencyPlanParamVo vo, Toke toke) throws Exception {
        ContingencyPlanResponseVo result = new ContingencyPlanResponseVo();
        //状态校验
        logger.info("========状态校验===========");
        ReserveEnum reserveEnum = this.runCheck(vo);
        result.setMessage(reserveEnum.getText());
        planStepService.initPlanStep();
        if (ReserveEnum.THISRUNNING.getStatus().equals(reserveEnum.getStatus())) {
            List<PlanOperationRecord> recordList = planOperationRecordDao.findByPlanId1(Long.valueOf(vo.getPlanId()));
            result.setMessage(ReserveEnum.THISRUNNING.getText());
            result.setBatchNo(recordList.get(0).getBatchNo());
            return result;
        } else if (ReserveEnum.RUN.getStatus().equals(reserveEnum.getStatus())) {
            Optional<PlanDetail> PlanDetailOp = planDetailDao.findById(Long.valueOf(vo.getPlanId()));
            List<PlanEquipment> equipmentList = planEquipmentDao.findByPlanId(PlanDetailOp.get().getId());
            //预案启动
            //获取规则名称
            List<PlanRule> planRuleList = planRuleDao.getPlanDocsByPlanId(Long.valueOf(vo.getPlanId()));
            if (planRuleList.size() == 0) {
                result.setMessage(ReserveEnum.NOPLAN.getText());
                return result;
            }
            //电力设备
            Equipment equipment = equipmentService.queryOne(equipmentList.get(0).getFireEquipmentId());
            if (equipment == null) {
                result.setMessage(ReserveEnum.NOEQUIP.getText());
                return result;
            }
            equipment.setReservePlan("换流站消防专项预案" + "/" + planRuleList.get(0).getRuleId());

            //电力设备绑定装备
            EquipmentSpecificForRiskVo equipmentSpecific;
            if (vo.getFireEquipmentId() != null) {
                equipmentSpecific = equipmentSpecificMapper.getOneById(vo.getFireEquipmentId());
                //不会为null 在告警处理时已经判断过
                if (equipmentSpecific == null) {
                    result.setMessage("该预案保护的电力设备尚未绑定配套的火灾报警设备");
                    return result;
                }
            } else {
                List<EquipmentFireEquipment> equipmentFireEquipmentList = equipmentFireEquipmentDao.findAllByEquipmentId(equipmentList.get(0).getFireEquipmentId());
                if (equipmentFireEquipmentList.size() == 0) {
                    result.setMessage("该预案保护的电力设备尚未绑定配套的火灾报警设备");
                    return result;
                }
                //查询设备
                equipmentSpecific = equipmentSpecificMapper.getOneById(equipmentFireEquipmentList.get(0).getFireEquipmentId());
                if (equipmentSpecific == null) {
                    result.setMessage("该预案保护的电力设备尚未绑定配套的火灾报警设备");
                    return result;
                }
            }
            String specificCode = equipmentSpecific.getCode();
            String specificName = equipmentSpecific.getName();
            Date date = new Date();
            // 插入预案基本信息
            ContingencyInstanceInfo instanceInfo = new ContingencyInstanceInfo();
            instanceInfo.setStartTime(date);
            instanceInfo.setEquipmentCode(specificCode);
            instanceInfo.setEquipmentName(specificName);
            //插入运行记录表
            PlanOperationRecord PlanOperationRecord = new PlanOperationRecord();
            PlanOperationRecord.setStatus(PlanRecordStatusEnum.OPERATION.getCode());
            PlanOperationRecord.setPlanId(PlanDetailOp.get().getId());
            PlanOperationRecord.setIsDelete(false);
            PlanOperationRecord.setStartTime(date);
            PlanOperationRecord.setPlanPattern(vo.getStatus());
            PlanOperationRecord.setStartUserId(vo.getUserId());
            PlanOperationRecord.setStartUserName(vo.getUserName());
            PlanOperationRecord.setEquipmentCode(specificCode);
            PlanOperationRecord.setEquipmentName(specificName);
            PlanOperationRecord.setEquipmentId(equipmentSpecific.getId());
            PlanOperationRecord.setFireEquipmentId(equipment.getId());
            if (ContingencyPlanStatusEnum.SIMULATION_START.getCode().equals(vo.getStatus())) {
                PlanOperationRecord.setExecutionType(ExecutionTypeEnum.PLANCHECK.getCode());
            } else {
                PlanOperationRecord.setExecutionType(ExecutionTypeEnum.FIREMANAGEMENT.getCode());
            }
            PlanOperationRecord operationRecord = planOperationRecordDao.save(PlanOperationRecord);
            //  异步数据同步之消息发送
            planOperationRecordDataSync(operationRecord);
            //预案启动
            AlarmParam deviceData = new AlarmParam();
            deviceData.setMonitor(equipment.getName());
            deviceData.setId(String.valueOf(equipmentSpecific.getId()));
            deviceData.setCode(equipmentSpecific.getCode());
            boolean isMock = vo.getStatus() == 4;
            deviceData.setIsMock(isMock);
            redisTemplate.opsForValue().set("isMock", isMock ? "true" : "false");
            String batchNo = equipmentHandlerService.executeDynamicPlan(deviceData, equipment, equipmentSpecific, toke, operationRecord.getId());
            //更新模型状态
            PlanDetail planDetail = PlanDetailOp.get();
            planDetail.setStatus(vo.getStatus());
            PlanDetail detail = planDetailDao.save(planDetail);
            //  异步数据同步之消息发送
            planDetailDataSync(detail);
            //更新预案执行记录表的批次号
            operationRecord.setBatchNo(batchNo);
            PlanOperationRecord record = planOperationRecordDao.save(operationRecord);
            // 保存预案基本信息
            instanceInfo.setId(batchNo);
            instanceInfo.setName(detail.getPlanName());
            instanceInfo.setOrgCode(detail.getOrgCode());
            instanceInfo.setPosition(equipmentSpecific.getPosition());
            
            contingencyInstanceInfoService.addDisposalDetails(instanceInfo);
            //  异步数据同步之消息发送
            planOperationRecordDataSync(record);
            result.setMessage(ReserveEnum.RUN.getText());
            result.setBatchNo(batchNo);

            String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
            Map<String, Object> map = new HashMap<>();
            map.put("contingency", new ContingencyRo());
            map.put("msgContext", "{\"content\":\"startPlan\"}");
            map.put("msgType", "refreshRecord");
            webMqttComponent.publish(topic, JSON.toJSONString(map));
        }
        return result;
    }

    private void planOperationRecordDataSync(PlanOperationRecord operationRecord) {
        if (dataSyncSwitch) {
            try {
                dataSyncService.asyncInvoke(() -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("id", operationRecord.getId());
                    List<PlanOperationRecordSyncBo> planOperationRecordSyncBoList = planOperationRecordMapper.getPlanOperationRecordSyncBoList(map);
                    dataSyncService.syncCreatedPlanOperationRecordSyncBo(planOperationRecordSyncBoList);
                });
            } catch (Exception e) {
                logger.info("数据同步之消息发送. [method='{}']", "planStart==>syncCreatedPlanOperationRecordSyncBo", e);
            }
        }
    }

    @Override
    public Map<String, Object> firstGetRecord(String batchNo) {
        Map<String, Object> map = new HashMap<>();
        PlanOperationRecord PlanOperationRecord = planOperationRecordDao.findByBatchNo(batchNo);
        if (PlanOperationRecord == null) {
            throw new YeeException("执行记录不存在");
        } else {
            PlanDetail planDetail = planDetailDao.getOne(PlanOperationRecord.getPlanId());
            if (planDetail == null) {
                throw new YeeException("数字预案模型被删除");
            }
            map.put("status", PlanOperationRecord.getStatus());
            if (PlanRecordStatusEnum.OPERATION == PlanRecordStatusEnum.getEnum(PlanOperationRecord.getStatus())) {
                map.put("executionTime", (System.currentTimeMillis() - PlanOperationRecord.getStartTime().getTime()) / 1000);
            } else {
                map.put("executionTime", (PlanOperationRecord.getEndTime().getTime() - PlanOperationRecord.getStartTime().getTime()) / 1000);
            }
            map.put("crateDate", PlanOperationRecord.getStartTime());
            if (ContingencyPlanStatusEnum.getEnum(PlanOperationRecord.getPlanPattern()) == ContingencyPlanStatusEnum.SIMULATION_START) {
                map.put("userName", PlanOperationRecord.getStartUserName());
                map.put("startType", "手动");
            } else {
                map.put("userName", "系统");
                map.put("startType", "自动");
            }
            map.put("executionType", PlanOperationRecord.getExecutionType());
            map.put("equipmentName", PlanOperationRecord.getEquipmentName());
            map.put("PlanName", planDetail.getPlanName());
        }
        return map;
    }

    @Override
    public List<HashMap<String, Object>> getRecordList(String batchNo) {
        List<HashMap<String, Object>> list = new ArrayList<>();
        List<ContingencyPlanInstance> instancesList = repository.queryForCategory(batchNo, "MESSAGE");
        instancesList.forEach(contingencyPlanInstance -> {
            HashMap<String, Object> map = new HashMap<>();
            map.put("crateDate", contingencyPlanInstance.getCreateDate());
            map.put("content", contingencyPlanInstance.getContent());
            list.add(map);
        });
        return list;
    }

    @Override
    public List<HashMap<String, Object>> getBatchNoByCode(String code) {
        List<HashMap<String, Object>> list = new ArrayList<>();
        String idByCode = equipmentSpecificMapper.getIdByCode(code);
        if (StringUtils.isEmpty(idByCode)) {
            return list;
        }
        String equipId = equipmentSpecificMapper.getEquipId(idByCode);
        if (StringUtils.isEmpty(equipId)) {
            return list;
        }
        String batchNoByEquipId = equipmentSpecificMapper.getBatchNoByEquipId(equipId);
        if (StringUtils.isEmpty(batchNoByEquipId)) {
            return list;
        }
        List<ContingencyPlanInstance> instancesList = repository.queryForCategoryOrderByCreateDate(batchNoByEquipId, "MESSAGE");
        instancesList.forEach(contingencyPlanInstance -> {
            HashMap<String, Object> map = new HashMap<>();
            map.put("crateDate", contingencyPlanInstance.getCreateDate());
            map.put("content", contingencyPlanInstance.getContent());
            list.add(map);
        });
        return list;
    }

    //启动状态校验
    public ReserveEnum runCheck(ContingencyPlanParamVo vo) throws Exception {
        logger.info("========vo===========" + JSONObject.toJSONString(vo));
        if (EquipmentRiskTypeEnum.HZGJ.getCode().equals(vo.getRiskType()) || StringUtils.isBlank(vo.getRiskType())) {

            List<PlanDoc> planDocs = planDocDao.findAllByPlanId(Long.valueOf(vo.getPlanId()));
            if (planDocs.size() == 0) {
                return ReserveEnum.PLAN_DOC_IS_DELETE;
            }
            //判断预案文档是否删除
            List<PlanRule> planRules = planRuleDao.findAllByPlanId(Long.valueOf(vo.getPlanId()));
            if (planRules.size() == 0) {
                return ReserveEnum.PLAN_RULE_IS_DELETE;
            }
            //判断预案装备是否删除
            List<PlanEquipment> planEquipments = planEquipmentDao.findByPlanId(Long.valueOf(vo.getPlanId()));
            if (planEquipments.isEmpty()) {
                return ReserveEnum.PLAN_EQUIP_IS_DELETE;
            }
            List<PlanOperationRecord> recordList = planOperationRecordDao.findByPlanId1(Long.valueOf(vo.getPlanId()));
            if (recordList.size() > 0 && !vo.getStatus().equals(ContingencyPlanStatusEnum.ONGOING.getCode())) {
                return ReserveEnum.THISRUNNING;
            }
            if (ContingencyPlanStatusEnum.SIMULATION_START.getCode().equals(vo.getStatus())) {
                Integer[] statusArray = (Integer[]) Arrays.asList(ContingencyPlanStatusEnum.SIMULATION_START.getCode(), ContingencyPlanStatusEnum.ONGOING.getCode()).toArray();
                List<PlanDetail> count = planDetailDao.findByStatus(statusArray);
                if (count.size() > NumberEnum.ZERO.getValue()) {
                    return ReserveEnum.RUNNING;
                }

            } else if (ContingencyPlanStatusEnum.ONGOING.getCode().equals(vo.getStatus())) {
                //自动启动
                List<PlanDetail> countZd = planDetailDao.findByStatus((Integer[]) Arrays.asList(ContingencyPlanStatusEnum.ONGOING.getCode()).toArray());
                if (countZd.size() > NumberEnum.ZERO.getValue()) {
                    return ReserveEnum.RUNNING;
                }
                List<PlanDetail> countMn = planDetailDao.findByStatus((Integer[]) Arrays.asList(ContingencyPlanStatusEnum.SIMULATION_START.getCode()).toArray());
                if (countMn.size() > NumberEnum.ZERO.getValue()) {
                    List<PlanOperationRecord> PlanOperationRecordList = planOperationRecordDao.findByPlanId1(countMn.get(0).getId());
                    if (PlanOperationRecordList.size() > 0) {
                        Optional<Equipment> equipment = iContingencyInstance.fire(PlanOperationRecordList.get(0).getBatchNo(), "0", "", "FIRE_CANCEL", "CONFIRM", "B");
                        //  结束预案，更新设备重点设备参数
                        equipment.ifPresent(equip -> {
                            equip.setStartTime(DateUtil.getDateNow());
                            equip.setEndTime(null);
                            equip.setReserveSource(NumberEnum.ONE.getValue());
                            equip.setStatus(NumberEnum.ONE.getValue());
                            equipmentService.save(equip);
                        });
                        customerAction.intreeuptPlan(PlanOperationRecordList.get(0).getBatchNo());
                    }
                }

            } else {
                return ReserveEnum.PLANSTATUSERROR;
            }
        } else {

        }
        return ReserveEnum.RUN;
    }

    @Override
    public ContingencyPlanParamVo equipmentScene(Long equipmentId, String riskType) {
        ContingencyPlanParamVo vo = null;
        if (EquipmentRiskTypeEnum.HZGJ.getCode().equals(riskType)) {
            List<EquipmentFireEquipment> equipmentFireEquipmentList = equipmentFireEquipmentDao.findAllByFireEquipmentId(equipmentId);
            if (!equipmentFireEquipmentList.isEmpty()) {
                List<Long> ids = new ArrayList<>();
                equipmentFireEquipmentList.forEach(e -> ids.add(e.getEquipmentId()));
                List<PlanEquipment> all = planEquipmentDao.findAllByFireEquipmentIdIn(ids);
                PlanEquipment planEquipment = all.isEmpty() ? null : all.get(0);
                if (planEquipment != null) {
                    vo = new ContingencyPlanParamVo();
                    vo.setPlanId(planEquipment.getPlanId().toString());
                    vo.setStatus(ContingencyPlanStatusEnum.ONGOING.getCode());
                    vo.setRiskType(riskType);
                    return vo;
                }
            }
        }
        return vo;
    }

    @Override
    public Page recordListByPage(Page page, Long planId, String planName, List<Long> classifyId, Date
            startTimeLeft, Date startTimeRight, Integer executionType, Integer planPattern) {
        Map<String, Object> params = new HashMap<>();
        params.put("planName", planName);
        params.put("planId", planId);
        params.put("start", (int) ((page.getCurrent() - 1) * page.getSize()));
        params.put("size", (int) page.getSize());
        params.put("classifyId", classifyId);
        params.put("startTimeLeft", startTimeLeft);
        params.put("startTimeRight", startTimeRight);
        params.put("executionType", executionType);
        params.put("planPattern", planPattern);

        int total = planOperationRecordMapper.filterCount(params);
        page.setTotal(total);
        long start = (page.getCurrent() - 1) * page.getSize();
        if (total == 0) {
            page.setCurrent(1);
        } else {
            if (total < start) {
                page.setCurrent(1);
                params.put("start", 0);
            }
            List<Map<String, Object>> planList = planOperationRecordMapper.filterList(params);
            page.setRecords(planList);
        }
        return page;
    }

    @Override
    public PlanDetailVo createPlan(PlanDetailVo planDetail) {
        PlanDoc planDoc = planDetail.getPlanDoc();
        PlanRule planRule = planDetail.getPlanRule();
        List<PlanEquipment> planEquipment = planDetail.getPlanEquipment();
        if (StringUtils.isBlank(planDetail.getPlanName()) || null == planDetail.getClassifyId()
                || null == planDoc || null == planDoc.getDocId()
                || null == planRule || null == planRule.getRuleId()
                || null == planEquipment || planEquipment.isEmpty()) {
            throw new YeeException("参数错误");
        }
        planEquipment.forEach(equipment -> {
            if (null == equipment || null == equipment.getFireEquipmentId()) {
                throw new YeeException("参数错误");
            }
        });
        // 状态为草稿
        planDetail.setStatus(ContingencyPlanStatusEnum.DRAFT.getCode());
        planDetail.setIsDelete(false);
        PlanDetail planEntity = new PlanDetail();
        BeanUtils.copyProperties(planDetail, planEntity);
        PlanDetail detail = planDetailDao.save(planEntity);
        //  异步数据同步之消息发送
        planDetailDataSync(detail);
        long planId = detail.getId();
        planDetail.setId(planId);
        planDoc.setPlanId(planId);
        planDoc.setIsDelete(false);
        planDocDao.save(planDoc);
        planRule.setPlanId(planId);
        planRule.setIsDelete(false);
        planRuleDao.save(planRule);
        planEquipment.forEach(equipment -> {
            equipment.setPlanId(planId);
            equipment.setIsDelete(false);
        });
        planEquipmentDao.saveAll(planEquipment);
        return planDetail;
    }

    @Override
    public PlanDetailVo editPlan(PlanDetailVo planDetail) {
        PlanDoc planDoc = planDetail.getPlanDoc();
        PlanRule planRule = planDetail.getPlanRule();
        List<PlanEquipment> planEquipment = planDetail.getPlanEquipment();
        if (StringUtils.isBlank(planDetail.getPlanName()) || null == planDetail.getClassifyId()
                || null == planDoc || null == planDoc.getDocId()
                || null == planRule || null == planRule.getRuleId()
                || null == planEquipment || planEquipment.isEmpty()) {
            throw new YeeException("参数错误");
        }
        planEquipment.forEach(equipment -> {
            if (null == equipment || null == equipment.getFireEquipmentId()) {
                throw new YeeException("参数错误");
            }
        });
        long planId = planDetail.getId();
        PlanDetail oldPlan = planDetailDao.findById(planId).orElse(null);
        if (null == oldPlan) {
            throw new YeeException("数据不存在");
        }
        if (ContingencyPlanStatusEnum.getEnum(oldPlan.getStatus()) == ContingencyPlanStatusEnum.DRAFT
                || ContingencyPlanStatusEnum.getEnum(oldPlan.getStatus()) == ContingencyPlanStatusEnum.NOAVAILABLE) {
            // 状态设置为草稿
            planDetail.setStatus(ContingencyPlanStatusEnum.DRAFT.getCode());
        } else {
            throw new YeeException("不可编辑的状态");
        }
        if (planDetail.getIsDelete() == null) {
            planDetail.setIsDelete(false);
        }
        PlanDetail planEntity = new PlanDetail();
        BeanUtils.copyProperties(planDetail, planEntity);
        planEntity.setOrgCode(oldPlan.getOrgCode());
        planEntity.setCreator(oldPlan.getCreator());
        PlanDetail detail = planDetailDao.saveAndFlush(planEntity);
        //  异步数据同步之消息发送
        planDetailDataSync(detail);

        planDoc.setPlanId(planId);
        planDoc.setIsDelete(false);
        planDocDao.deleteByPlanId(planId);
        planDocDao.save(planDoc);

        planRule.setPlanId(planId);
        planRule.setIsDelete(false);
        planRuleDao.deleteByPlanId(planId);
        planRuleDao.save(planRule);

        planEquipment.forEach(equipment -> {
            equipment.setPlanId(planId);
            equipment.setIsDelete(false);
        });
        planEquipmentDao.deleteByPlanId(planId);
        planEquipmentDao.saveAll(planEquipment);
        return planDetail;
    }

    @Override
    public PlanDetailVo detail(Long id) {
        PlanDetail detail = planDetailDao.findById(id).orElse(null);
        if (null == detail) {
            throw new YeeException("数据不存在");
        }
        PlanDetailVo detailVo = new PlanDetailVo();
        BeanUtils.copyProperties(detail, detailVo);
        List<PlanDoc> docs = planDocDao.getPlanDocsByPlanId(id);
        if (!docs.isEmpty()) {
            detailVo.setPlanDoc(docs.get(0));
        }
        List<PlanRule> rules = planRuleDao.getPlanDocsByPlanId(id);
        if (!rules.isEmpty()) {
            detailVo.setPlanRule(rules.get(0));
        }
        List<PlanEquipment> equipments = planEquipmentDao.getPlanDocsByPlanId(id);
        detailVo.setPlanEquipment(equipments);
        // 设置执行次数
        detailVo.setExecutionTimes(planOperationRecordDao.countByPlanId(id));
        PlanClassifyTree classifyTree = classifyTreeDao.findById(detailVo.getClassifyId()).orElse(null);
        if (null != classifyTree) {
            detailVo.setClassifyName(classifyTree.getClassifyName());
        }
        return detailVo;
    }

    @Override
    public List<PlanDetail> activatePlan(List<Long> idList) {
        List<PlanDetail> planDetailList = planDetailDao.getPlanDetailsByIdInAndIsDelete(idList, false);
        if (!planDetailList.isEmpty()) {
            planDetailList.forEach(plan -> {
                ContingencyPlanStatusEnum status = ContingencyPlanStatusEnum.getEnum(plan.getStatus());
                if (status != ContingencyPlanStatusEnum.DRAFT
                        && status != ContingencyPlanStatusEnum.AVAILABLE
                        && status != ContingencyPlanStatusEnum.NOAVAILABLE) {
                    throw new YeeException("包含不可启用的状态");
                }
                plan.setStatus(ContingencyPlanStatusEnum.AVAILABLE.getCode());
            });
            int update = planDetailMapper.updatePlanStatusByIdList(idList, ContingencyPlanStatusEnum.AVAILABLE.getCode());
            //  异步数据同步之消息发送
            planDetailDataSync(idList, update);
        }
        return planDetailList;
    }

    @Override
    public List<PlanDetail> deactivatePlan(List<Long> idList) {
        List<PlanDetail> planDetailList = planDetailDao.getPlanDetailsByIdInAndIsDelete(idList, false);
        if (!planDetailList.isEmpty()) {
            planDetailList.forEach(plan -> {
                if (ContingencyPlanStatusEnum.getEnum(plan.getStatus()) != ContingencyPlanStatusEnum.AVAILABLE
                        && ContingencyPlanStatusEnum.getEnum(plan.getStatus()) != ContingencyPlanStatusEnum.NOAVAILABLE) {
                    throw new YeeException("包含不可禁用的状态");
                }
                plan.setStatus(ContingencyPlanStatusEnum.NOAVAILABLE.getCode());
            });
            int update = planDetailMapper.updatePlanStatusByIdList(idList, ContingencyPlanStatusEnum.NOAVAILABLE.getCode());
            //  异步数据同步之消息发送
            planDetailDataSync(idList, update);
        }
        return planDetailList;
    }

    private void planDetailDataSync(PlanDetail planDetail) {
        //  异步数据同步之消息发送
        if (dataSyncSwitch) {
            try {
                dataSyncService.asyncInvoke(() -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("id", planDetail.getId());
                    List<PlanDetailSyncBo> planDetailSyncBoList = planDetailMapper.getPlanDetailSyncBoList(map);
                    dataSyncService.syncCreatedPlanDetailSyncBo(planDetailSyncBoList);
                });
            } catch (Exception e) {
                logger.info("数据同步之消息发送. [method='{}']", "planDetailDataSync==>syncCreatedPlanDetailSyncBo", e);
            }
        }
    }

    private void planDetailDataSync(List<Long> idList, int update) {
        if (update > 0 && dataSyncSwitch) {
            try {
                dataSyncService.asyncInvoke(() -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("idList", idList);
                    List<PlanDetailSyncBo> planDetailSyncBoList = planDetailMapper.getPlanDetailSyncBoList(map);
                    dataSyncService.syncCreatedPlanDetailSyncBo(planDetailSyncBoList);
                });
            } catch (Exception e) {
                logger.info("数据同步之消息发送. [method='{}']", "planDetailDataSync==>syncCreatedPlanDetailSyncBo", e);
            }
        }
    }

    @Override
    public Boolean delete(List<Long> idList) {
        int update = planDetailMapper.updateIsDeleteByIdList(idList, true);
        planDocMapper.updateIsDeleteByPlanIdList(idList, true);
        planEquipmentMapper.updateIsDeleteByPlanIdList(idList, true);
        planRuleMapper.updateIsDeleteByPlanIdList(idList, true);
        //  异步数据同步之消息发送
        planDetailDataSync(idList, update);
        return true;
    }

    @Override
    public Page<PlanDetailVo> pageFilter(Page page, String planName, Long
            classifyId, List<String> planRange, String editOrgName, Date implementationTimeLeft, Date
                                                 implementationTimeRight) {
        List<Long> classifyIdList = new ArrayList<>();
        if (classifyId != null) {
            Collection<PlanClassifyTreeVo> classifyTreeList = planClassifyTreeService.getAllChildIncludeMe(classifyId);
            if (!classifyTreeList.isEmpty()) {
                List<PlanClassifyTreeVo> allChildren = TreeUtil.getAllChildren(classifyTreeList);
                allChildren.forEach(e -> classifyIdList.add(e.getId()));
            }
        }
        int total = planDetailMapper.filterCount(planName, classifyIdList, planRange, editOrgName, implementationTimeLeft, implementationTimeRight);
        page.setTotal(total);
        long start = (page.getCurrent() - 1) * page.getSize();
        if (total == 0) {
            page.setCurrent(1);
        } else {
            if (total < start) {
                page.setCurrent(1);
                start = 0;
            }
            List<PlanDetailVo> planList = planDetailMapper.filterList(planName, classifyIdList, planRange, editOrgName, implementationTimeLeft, implementationTimeRight, (int) start, (int) page.getSize());
            // 查询并插入绑定数据的信息
            fillBindingInfo(planList);
            page.setRecords(planList);
        }
        return page;
    }

    private void fillBindingInfo(List<PlanDetailVo> planList) {
        if (ValidationUtil.isEmpty(planList)) {
            return;
        }
        List<Long> idList = new ArrayList<>();
        planList.forEach(e -> idList.add(e.getId()));
        Map<Object, List<PlanDoc>> docMapList = null;
        Map<Object, List<PlanRule>> ruleMapList = null;
        Map<Object, List<PlanEquipment>> equipMapList = null;
        List<PlanDoc> docs = planDocDao.findAllByPlanIdIn(idList);
        if (!docs.isEmpty()) {
            docMapList = Bean.list2MapList(docs, "planId");
        }
        List<PlanRule> rules = planRuleDao.findAllByPlanIdIn(idList);
        if (!rules.isEmpty()) {
            ruleMapList = Bean.list2MapList(rules, "planId");
        }
        List<PlanEquipment> equips = planEquipmentDao.findAllByPlanIdIn(idList);
        if (!equips.isEmpty()) {
            equipMapList = Bean.list2MapList(equips, "planId");
        }
        Map<Object, List<PlanDoc>> finalDocMapList = docMapList;
        Map<Object, List<PlanRule>> finalRuleMapList = ruleMapList;
        Map<Object, List<PlanEquipment>> finalEquipMapList = equipMapList;
        planList.forEach(plan -> {
            if (finalDocMapList != null && finalDocMapList.get(plan.getId()) != null) {
                plan.setPlanDoc(finalDocMapList.get(plan.getId()).get(0));
            }
            if (finalRuleMapList != null && finalRuleMapList.get(plan.getId()) != null) {
                plan.setPlanRule(finalRuleMapList.get(plan.getId()).get(0));
            }
            if (finalEquipMapList != null && finalEquipMapList.get(plan.getId()) != null) {
                plan.setPlanEquipment(finalEquipMapList.get(plan.getId()));
            }
        });
    }

    @Override
    public Map<Long, Long> getPlanUsedDocs() {
        Map<Long, Long> resMap = new HashMap<>(64);
        List<PlanDoc> usedList = planDocDao.findAllByIsDelete(false);
        if (!usedList.isEmpty()) {
            usedList.forEach(planDoc -> resMap.put(planDoc.getDocId(), planDoc.getPlanId()));
        }
        return resMap;
    }

    @Override
    public Map<String, Long> getPlanUsedRules() {
        Map<String, Long> resMap = new HashMap<>(64);
        List<PlanRule> usedList = planRuleDao.findAllByIsDelete(false);
        if (!usedList.isEmpty()) {
            usedList.forEach(planRule -> resMap.put(planRule.getRuleId(), planRule.getPlanId()));
        }
        return resMap;
    }

    @Override
    public Map<Long, Long> getPlanUsedEquipments() {
        Map<Long, Long> resMap = new HashMap<>(64);
        List<PlanEquipment> usedList = planEquipmentDao.findAllByIsDelete(false);
        if (!usedList.isEmpty()) {
            usedList.forEach(planEquipment -> resMap.put(planEquipment.getFireEquipmentId(), planEquipment.getPlanId()));
        }
        return resMap;
    }

    @Override
    public void subscribeTopic() {
        try {
            emqKeeper.getMqttClient().subscribe(DELETE_SYNC_PLAN_DOC, (s, mqttMessage) -> {
                byte[] payload = mqttMessage.getPayload();
                try {
                    List<Long> ids = (List<Long>) ClazzUtils.deserializableObject(payload);
                    if (!ValidationUtil.isEmpty(ids)) {
                        planDocMapper.logicDeleteByDocIdList(ids);
                    }
                } catch (Exception e) {
                    logger.error("预案文档删除同步出错", e);
                }
            });
        } catch (MqttException e) {
            logger.fatal("订阅文档删除同步消息失败，资源删除或取消无法同步", e);
        }
        try {
            emqKeeper.getMqttClient().subscribe(DELETE_SYNC_PLAN_RULE, (s, mqttMessage) -> {
                byte[] payload = mqttMessage.getPayload();
                try {
                    String[] ids = new String(payload).split(",");
                    if (!ValidationUtil.isEmpty(ids)) {
                        planRuleMapper.logicDeleteByRuleIdList(Arrays.asList(ids));
                    }
                } catch (Exception e) {
                    logger.error("预案规则删除同步出错", e);
                }
            });
        } catch (MqttException e) {
            logger.fatal("订阅规则删除同步消息失败，资源删除或取消无法同步", e);
        }
        try {
            emqKeeper.getMqttClient().subscribe(VIEW_3D_OPEN_STATUS, (s, mqttMessage) -> {
                Map msg = JSON.parseObject(mqttMessage.toString());
                if (msg.containsKey("status") && msg.containsKey("seq")) {
                    String seq = msg.get("seq").toString();
                    String status = msg.get("status").toString();
                    String key = KEY_VIEW_3D_PAGE + seq;
                    if ("offLine".equals(status)) {
                        redisTemplate.delete(key);
                    } else {
                        redisTemplate.opsForValue().set(key, status);
                    }
                }
            });
        } catch (MqttException e) {
            logger.fatal("订阅规则删除同步消息失败，资源删除或取消无法同步", e);
        }
    }

    @Override
    public AtomicBoolean planReset() {
        AtomicBoolean bool = new AtomicBoolean(true);
        try {
            // 运行中的设置为重置
            List<PlanOperationRecord> planList = planOperationRecordDao.findByStatus(0);
            if (!planList.isEmpty()) {
                planList.forEach(PlanOperationRecord -> {
                    String batchNo = PlanOperationRecord.getBatchNo();
                    customerAction.intreeuptPlan(batchNo);
                    redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                    Optional<Equipment> equipment;
                    try {
                        equipment = iContingencyInstance.fire(batchNo, "0", "", "FIRE_CANCEL", "CONFIRM", "B");
                        //  结束预案，更新设备重点设备参数
                        equipment.ifPresent(equip -> {
                            equip.setEndTime(null);
                            equip.setReserveSource(NumberEnum.ONE.getValue());
                            equip.setStartTime(DateUtil.getDateNow());
                            equip.setStatus(NumberEnum.ONE.getValue());
                            equipmentService.save(equip);
                        });
                    } catch (Exception e) {
                        logger.info("预案重置失败batchNo:{}", batchNo, e);
                        e.printStackTrace();
                    }
                });
            }

            //  异步数据同步之消息发送
            if (!planList.isEmpty() && dataSyncSwitch) {
                try {
                    dataSyncService.asyncInvoke(() -> {
                        Map<String, Object> map = new HashMap<>();
                        map.put("status", "2");
                        List<PlanDetailSyncBo> planDetailSyncBoList = planDetailMapper.getPlanDetailSyncBoList(map);
                        dataSyncService.syncCreatedPlanDetailSyncBo(planDetailSyncBoList);

                        Map<String, Object> mapRecord = new HashMap<>();
                        mapRecord.put("status", "1");
                        List<PlanOperationRecordSyncBo> planOperationRecordSyncBoList = planOperationRecordMapper.getPlanOperationRecordSyncBoList(mapRecord);
                        dataSyncService.syncCreatedPlanOperationRecordSyncBo(planOperationRecordSyncBoList);
                    });
                } catch (Exception e) {
                    logger.info("数据同步之消息发送. [method='{}']", "activatePlan==>syncCreatedPlanDetailSyncBo==>syncCreatedPlanOperationRecordSyncBo", e);
                }
            }
        } catch (Exception e) {
            bool.set(false);
            e.printStackTrace();
        }
        return bool;
    }

    @Override
    public List<PlanOperationRecord> getPlanStatus() {
        return planOperationRecordDao.findByStatus(0);
//        return CollectionUtils.isEmpty(planOperationRecordDao.findByStatus(0));
    }

    @Override
    public String getPlanBatchNo() {
        List<PlanOperationRecord> records = planOperationRecordDao.findByStatus(0);
        if (!CollectionUtils.isEmpty(records)) {
            return records.get(0).getBatchNo();
        }
        return "";
    }

    @Override
    public Map<String, Object> getUserOperateCountAndPlanName(List<RoleModel> roleModelList) {
        Map<String, Object> map = new HashMap<>();
        List<PlanOperationRecord> recordList = planOperationRecordDao.findByStatus(0);
        if (!CollectionUtils.isEmpty(recordList)) {
            PlanOperationRecord record = recordList.get(0);
            String batchNo = record.getBatchNo();
            ContingencyInstanceInfoVO instanceInfo = contingencyInstanceInfoService.selectDisposalDetails(batchNo);
            if (instanceInfo != null) {
                map.put("planName", instanceInfo.getName());
                map.put("batchNo", batchNo);
                List<ContingencyPlanInstanceVO> list = planVisual3dService.selectDisposalActionList(batchNo, roleModelList, 1);
                map.put("taskNum", list.size());
            }
        }
        return map;
    }

}