package com.yeejoin.amos.fas.core.enums;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.core.enums
 * @ClassName: ReserveEnum
 * @Author: Jianqiang Gao
 * @Description: 预案启动状态
 * @Date: 2021/1/7 18:23
 * @Version: 1.0
 */
public enum ReserveEnum {
    RUN(1, "启动成功"),
    RUNNING(2, "已有预案正在启动"),
    NOFIRE(3, "该电力设备未安装火灾探测器"),
    NOEQUIP(4, "未找到该电力设备"),
    NOFIRENOPLAN(5, "非火灾告警没有预案"),
    PLANSTATUSERROR(6,"预案启动状态不正确"),
    NOPLAN(7,"预案模型未绑定预案"),
    THISRUNNING(8, "此预案正在启动中"),
    PLAN_DOC_IS_DELETE(9, "预案文档已经被删除，无法启动"),
    PLAN_RULE_IS_DELETE(10, "预案规则已经被删除，无法启动"),
    PLAN_EQUIP_IS_DELETE(10, "电力设备已经被删除，无法启动");
    private Integer status;
    private String text;

    ReserveEnum(Integer status, String text) {
        this.status = status;
        this.text = text;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }
}