package com.yeejoin.amos.fas.business.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.business.feign.OutTokenLoginFeign;
import com.yeejoin.amos.fas.business.feign.PrivilegeFeign;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.vo.CompanyBo;
import com.yeejoin.amos.fas.business.vo.DepartmentBo;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.business.vo.RoleBo;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zjw
 * @date 2020-03-30
 */


@RestController
@RequestMapping(value = "/api/loginBytoken")
@Api(tags = "外部token登录Api")
public class TokenLoginController {

    private static final Logger logger = LoggerFactory.getLogger(TokenLoginController.class);

    @Autowired
    private OutTokenLoginFeign outTokenLoginFeign;

    @Autowired
    private PrivilegeFeign privilegeFeign;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Value("${outSystem.user.password}")
    private String password;

    @Value("${security.productWeb}")
    private String product;

    @Value("${security.appKeyWeb}")
    private String appKey;

    @ApiOperation(value = "外部token登錄", notes = "查询设备指标")
    @GetMapping(value = "/{token}")
    synchronized  public ReginParams getBindEquipment(@PathVariable("token") String  outToken) throws Exception {
        if ( ObjectUtils.isEmpty(outToken)) {
            throw new Exception("token异常");
        }
        String userId = "wk";
//        String userId = outTokenLoginFeign.getUserName(outToken);
        if (ObjectUtils.isEmpty(userId)){
            throw new Exception("用户信息不存在");
        }

        ReginParams reginParams;
        reginParams = JSON.parseObject(redisTemplate.opsForValue().get(buildKey(userId, outToken)), ReginParams.class);
        if(reginParams == null){
            reginParams = new ReginParams();
            Map<String, String> param = new HashMap<>();
            param.put("loginId",userId);
            param.put("password",password);
            Object result = privilegeFeign.login(appKey, product, outToken, param).getResult();
            if (ObjectUtils.isEmpty(result)){
                throw new Exception("缺失登录信息");
            }

            Map<String ,String > re = (Map<String ,String >) result;
            String token = re.get("token");
            privilegeFeign.warrant(appKey,product,token);

            RequestContext.setToken(token);
            RequestContext.setProduct(product);
            RequestContext.setAppKey(appKey);

            AgencyUserModel userModel  =  (AgencyUserModel) Privilege.agencyUserClient.getme().getResult();
            CompanyModel companyModel = userModel.getCompanys().get(0);
            List<DepartmentModel> deptList = remoteSecurityService.getDepartmentTreeByCompanyId(token, product, appKey, companyModel.getSequenceNbr().toString());
            if(deptList.size() > 0){
                CompanyBo companyBo = convertCompanyModelToBo(companyModel);
                DepartmentBo departmentBo = convertDepartmentModelToBo(deptList.get(0));
                reginParams.setDepartment(departmentBo);
                reginParams.setCompany(companyBo);
            }

            reginParams.setToken(token);
            reginParams.setUserModel(userModel);

            redisTemplate.opsForValue().set(buildKey(userId, token), JSONObject.toJSONString(reginParams));
            redisTemplate.opsForValue().set(buildKey(userId, outToken), JSONObject.toJSONString(reginParams));

        }

        return reginParams;
    }
    private DepartmentBo convertDepartmentModelToBo(DepartmentModel departmentModel){
        DepartmentBo departmentBo = new DepartmentBo();
        if(departmentModel != null) {
            departmentBo.setCompanySeq(departmentModel.getCompanySeq().toString());
            departmentBo.setDepartmentDesc(departmentModel.getDepartmentDesc());
            departmentBo.setDepartmentName(departmentModel.getDepartmentName());
            departmentBo.setLevel(departmentModel.getLevel());
            departmentBo.setOrgCode(departmentModel.getOrgCode());
            departmentBo.setParentId(departmentModel.getParentId().toString());
            departmentBo.setDeptOrgCode(departmentModel.getDeptOrgCode().toString());
            departmentBo.setSequenceNbr(departmentModel.getSequenceNbr().toString());
        }
        return departmentBo;
    }

    /**
     * 	Model 转 Bo
     */
    private CompanyBo convertCompanyModelToBo(CompanyModel companyModel){
        CompanyBo companyBo = new CompanyBo();
        if(companyModel != null) {
            companyBo.setAddress(companyModel.getAddress());
            companyBo.setCompanyName(companyModel.getCompanyName());
            companyBo.setCompanyOrgCode(Long.parseLong(companyModel.getCompanyOrgCode().toString()));
            companyBo.setEmail(companyModel.getEmail());
            companyBo.setLandlinePhone(companyModel.getLandlinePhone());
            companyBo.setLongitude(companyModel.getLongitude());
            companyBo.setLatitude(companyModel.getLatitude());
            companyBo.setLevel(companyModel.getLevel());
            companyBo.setOrgCode(companyModel.getOrgCode());
            companyBo.setSequenceNbr(companyModel.getSequenceNbr().toString());
            companyBo.setParentId(companyModel.getParentId().toString());
        }
        return companyBo;
    }

    private RoleBo convertRoleModelToBo(RoleModel roleModel) {
        RoleBo roleBo = new RoleBo();
        if(roleModel != null){
            roleBo.setRoleName(roleModel.getRoleName());
            roleBo.setRoleType(roleModel.getRoleType());
            roleBo.setSequenceNbr(roleModel.getSequenceNbr().toString());
        }
        return roleBo;
    }

    private String buildKey(String userId, String token) {
        return "region_" + userId + "_" + token;

    }
}
