package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.Equipment;

import java.util.List;
import java.util.Optional;

public interface IContingencyInstance {

    ContingencyPlanInstance createInstanceRecord(String instanceNo, String category, String subCategory, String content, String recordType, String icon);



    List<ContingencyPlanInstance> queryForTimeLine(String instanceNo,String recordType) throws Exception;


    void setButtonExecuted(String batchNo,String contingencyPlanId,String code,String buttonState) throws Exception;
    void setButtonWait(String batchNo,String contingencyPlanId,String buttonState) throws Exception;


    Optional<Equipment> fire(String batchNo, String stepCode, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton) throws Exception;

    void updateStep(String step, String batchNo);

    Optional<Equipment> fire(String batchNo, String stepCode, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton, String token, String product, String appKey) throws Exception;

    /**
     * 扩展属性赋值
     * @param contingencyPlanInstance
     * @return
     */
    ContingencyPlanInstance updateExtendColumn(ContingencyPlanInstance contingencyPlanInstance);

    /**
     * 根据id 查询信息
     * @param id
     * @return
     */
    ContingencyPlanInstance getMessageById(String id);

    /**
     * 通过buttonCode获取执行角色编码
     * @param buttonCode
     * @return
     */
    String getPlanStepRoleCodeByButtonCode(String buttonCode);
}
