package com.yeejoin.amos.fas.business.service.intfc;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanInstanceVO;
import com.yeejoin.amos.fas.business.vo.MessageVO;
import com.yeejoin.amos.fas.business.vo.PlanStepVo;
import com.yeejoin.amos.fas.business.vo.TreeSubjectVo;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.TextPlan;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;

import java.util.List;
import java.util.Map;

public interface IPlanVisual3dService {

    /**
     * 获取预案树
     *
     * @return
     */
    List<TreeSubjectVo> getPlanTree();

    /**
     * 上传文字预案
     *
     * @param appId       预案ID
     * @param pathNameMap 文字预案文件路径:文件名称map
     */
    void uploadTextPlan(String appId, Map<String, String> pathNameMap);

    /**
     * 根据ID获取文本预案
     *
     * @param id
     * @return
     */
    TextPlan getTextPlanInfoById(Long id);

    CommonResponse getResourceListByType(String type);

    List<Map<String, Object>> getResourceById(String type, Long id);

    List<Map<String, Object>> getResourceTypeList();

    List<TreeSubjectVo> getTextPlanBySubjectId(String appId);

    void deleteTextPlanFile(Long id);

    /**
     * 查最新的批次号
     *
     * @return
     */
    String getNewestBatchNo();

    /**
     * 根据批次号获取预案步骤
     *
     * @param batchNo 批次号
     * @return 预案步骤
     */
    ToipResponse getPlanStepByBatchNo(String batchNo);

    /**
     * 根据批次号获取预案记录
     *
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordByBatchNo(String batchNo);

    /**
     * 根据批次号获取预案记录
     *
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordOneByBatchNo(String batchNo);

    PlanStepVo updatePlanStep(PlanStepVo planStepVo);

    Page<ContingencyPlanInstanceVO> selectDisposalActionPage(int current, int size, String batchNo, List<RoleModel> roleModelList, int dataType);

    /**
     * 根据批次号获取预案的消息等记录
     *
     * @param batchNo
     * @return
     */
    Page<ContingencyPlanInstanceVO> getPlaneRecordByNew(Integer pageNum, Integer size, String batchNo, AgencyUserModel user);

    ContingencyPlanInstance replyMessage(AgencyUserModel user, ContingencyPlanInstance dto);

    List<ContingencyPlanInstanceVO> selectDisposalActionList(String batchNo, List<RoleModel> roleModelList, int dataType);

    /**
     * 极光推送消息
     *
     * @param buttonCode
     * @param messageVO
     */
    void sendMessage(String buttonCode, MessageVO messageVO);


    /**
     * 修改动作执行状态
     *
     * @param id
     * @return
     */
    boolean updateStatusById(String id);
}
