package com.yeejoin.amos.fas.business.service.impl;


import com.yeejoin.amos.fas.business.dao.repository.IEquipmentFireEquipmentDao;
import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificIndexService;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentFireEquipmentService;
import com.yeejoin.amos.fas.common.enums.SqlKeyWordEnum;
import com.yeejoin.amos.fas.dao.entity.EquipmentFireEquipment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.service.impl
 * @ClassName: EquipmentFireEquipmentServiceImpl
 * @Author: Jianqiang Gao
 * @Description:
 * @Date: 2022/5/20 14:40
 * @Version: 1.0
 */
@Service
public class EquipmentFireEquipmentServiceImpl implements IEquipmentFireEquipmentService {

    private final Logger log = LoggerFactory.getLogger(EquipmentFireEquipmentServiceImpl.class);

    private static final String TYPE = "or";
    private static final String VALUE = "true";

    @Autowired
    private IEquipmentFireEquipmentService equipmentFireEquipmentService;

    @Autowired
    private EquipmentSpecificIndexService equipmentSpecificIndexService;

    @Autowired
    private IEquipmentFireEquipmentDao equipmentFireEquipmentDao;

    @Override
    public List<EquipmentFireEquipment> findByEquipmentId(Long equipmentId) {
        return equipmentFireEquipmentDao.findAllByEquipmentId(equipmentId);
    }

    @Override
    public List<EquipmentFireEquipment> findByEquipIdAndEquipCodeIn(Long equipmentId, String[] equipCodes) {
        return equipmentFireEquipmentDao.findByEquipIdAndEquipCodeIn(equipmentId, equipCodes);
    }

    @Override
    public List<EquipmentFireEquipment> findByEquipIdAndEquipSpeCodeIn(Long equipmentId, String[] equipSpeCodes) {
        return equipmentFireEquipmentDao.findByEquipIdAndEquipSpeCodeIn(equipmentId, equipSpeCodes);
    }

    @Override
    public Object automaticExecute(String equipmentId, String equipCode, String equipSpeCode, String type, String indexKeys, String value) {
        Map<String, Object> map = null;
        if (StringUtils.isBlank(type)) {
            type = TYPE;
        }
        if (StringUtils.isBlank(value)) {
            value = VALUE;
        }
        if (StringUtils.isNotBlank(equipmentId)) {
            //  1. 查询重点设备绑定的消防设备
            List<EquipmentFireEquipment> list = null;
            if (StringUtils.isBlank(equipSpeCode)) {
                if (StringUtils.isBlank(equipCode)) {
                    list = equipmentFireEquipmentService.findByEquipmentId(Long.parseLong(equipmentId));
                } else {
                    list = equipmentFireEquipmentService.findByEquipIdAndEquipCodeIn(Long.parseLong(equipmentId), equipCode.split(","));
                }
            } else {
                list = equipmentFireEquipmentService.findByEquipIdAndEquipSpeCodeIn(Long.parseLong(equipmentId), equipSpeCode.split(","));
            }
            if (!CollectionUtils.isEmpty(list)) {
                List<Long> equipSpecificIdList = list.stream().map(EquipmentFireEquipment::getFireEquipmentId).collect(Collectors.toList());
                //  2 获取消防设备满足条件的集合
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(equipSpecificIdList, null, null, indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(equipSpecificIdList, null, null, null, value);
                }
            }
        } else {
            //  不存在重点设备，直接查消防设备
            if (StringUtils.isNotBlank(equipSpeCode)) {
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, null, equipSpeCode.split(","), indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, null, equipSpeCode.split(","), null, value);
                }
            } else if (StringUtils.isNotBlank(equipCode)) {
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, equipCode.split(","), null, indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, equipCode.split(","), null, null, value);
                }
            }
        }
        if (!CollectionUtils.isEmpty(map)) {
            Integer total = Integer.parseInt(map.get("total").toString());
            Integer count = Integer.parseInt(map.get("count").toString());
            if (SqlKeyWordEnum.AND.getKey().equalsIgnoreCase(type)) {
                if (total.equals(count)) {
                    return true;
                }
            } else if (SqlKeyWordEnum.OR.getKey().equalsIgnoreCase(type)) {
                if (count != 0) {
                    return true;
                }
            }
        }
        return false;
    }
}
