package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.vo.TreeSubjectVo;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.TextPlan;

import java.util.List;
import java.util.Map;

public interface IPlanVisual3dService {

    /**
     * 获取预案树
     *
     * @return
     */
    List<TreeSubjectVo> getPlanTree();

    /**
     * 上传文字预案
     *  @param appId 预案ID
     * @param pathNameMap 文字预案文件路径:文件名称map
     */
    void uploadTextPlan(String appId, Map<String, String> pathNameMap);

    /**
     * 根据ID获取文本预案
     *
     * @param id
     * @return
     */
    TextPlan getTextPlanInfoById(Long id);

    CommonResponse getResourceListByType(String type);

    List<Map<String,Object>> getResourceById(String type,Long id);

    List<Map<String,Object>> getResourceTypeList();

	List<TreeSubjectVo> getTextPlanBySubjectId(String appId);

	void deleteTextPlanFile(Long id);

    /**
     * 查最新的批次号
     * @return
     */
	String getNewestBatchNo();

    /**
     * 根据批次号获取预案步骤
     * @param batchNo 批次号
     * @return 预案步骤
     */
    ToipResponse getPlanStepByBatchNo(String batchNo);

    /**
     * 根据批次号获取预案记录
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordByBatchNo(String batchNo);

    /**
     * 根据批次号获取预案记录
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordOneByBatchNo(String batchNo);
}
