package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;


/**
 * The persistent class for the c_emergency_task_content database table.
 */
@Entity
@Table(name = "c_emergency_task_content")
@Data
public class EmergencyTaskContent extends BasicEntity {
    private static final long serialVersionUID = 1L;

    //分工内容
    @Column(name = "content")
    private String content;

    //编号
    @Column(name = "code")
    private String code;

    //关联角色ID
    @Column(name = "obligation_id")
    private Long obligationId;

    //所属流程步骤编号
    @Column(name = "step_code")
    private String stepCode;

    //角色code
    @Column(name = "role_code")
    private String roleCode;

    //任务排序号
    @Column(name = "task_num")
    private String taskNum;

    //是否必填项
    @Column(name = "is_must")
    private boolean isMust;

    //所属流程步骤编号
    @Column(name = "button_json")
    private String buttonJson;

    //预案类型
    @Column(name = "plan_type")
    private String planType;

    //关联角色名称
    @Column(name = "obligation_name")
    private String obligationName;

    //是否必填项
    @Transient
    private String isMustString;

    //所属角色
    @Transient
    private ArrayList<String> roleCodeList;
}