package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;


/**
 * The persistent class for the equipment database table.
 * 
 */
@Entity
@Table(name="f_equipment")
@NamedQuery(name="Equipment.findAll", query="SELECT e FROM Equipment e")
@Data
public class Equipment extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	private String address;

	private String building;

	/**
	 * 所属风险区域id
	 */
	@Column(name="risk_source_id")
	private Long riskSourceId;
	/**
	 * 3维坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;
	
	/**
	 * 预案配置
	 */
	@Column(name="reserve_plan")
	private String reservePlan;

	/**
	 * 是否室内 0-否 1-是
	 */
	@Column(name="is_indoor")
	private Boolean isIndoor;

	@Column(name="charge_dept_id")
	private String chargeDeptId;

	@Column(name="charge_user_id")
	private String chargeUserId;

	private String code;

	@Column(name="fire_truck_route")
	private String fireTruckRoute;


	public String getFireTruckRoute() {
		return fireTruckRoute;
	}

	public void setFireTruckRoute(String fireTruckRoute) {
		this.fireTruckRoute = fireTruckRoute;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	private String room;
	
	/**
	 * 关联消防小室id
	 */
	@Column(name="fire_station_id")
	private Long fireStationId;

	

	@Column(name="create_by")
	private String createBy;

	private String name;

	@Column(name="org_code")
	private String orgCode;

	private String remark;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	private Integer status;

	/**
	 *	预案开始时间
	 */
	@Column(name="start_time")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startTime;

	/**
	 * 预案结束时间
	 */
	@Column(name="end_time")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endTime;

	/**
	 * 预案来源：1-手动触发，0-自动触发（默认）
	 */
	@Column(name="reserve_source")
	private Integer reserveSource;

	/**
	 * 排空时长（分钟）
	 */
	@Column(name="drain_duration")
	private Double drainDuration;

	/**
	 * 分类
	 */
	@Column(name="category")
	private String category;

	public Equipment() {
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getBuilding() {
		return this.building;
	}

	public void setBuilding(String building) {
		this.building = building;
	}

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	

	public String getChargeDeptId() {
		return chargeDeptId;
	}

	public void setChargeDeptId(String chargeDeptId) {
		this.chargeDeptId = chargeDeptId;
	}

	public String getChargeUserId() {
		return chargeUserId;
	}

	public void setChargeUserId(String chargeUserId) {
		this.chargeUserId = chargeUserId;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	public Long getFireStationId() {
		return fireStationId;
	}

	public void setFireStationId(Long fireStationId) {
		this.fireStationId = fireStationId;
	}
	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}


	public String getRoom() {
		return room;
	}

	public void setRoom(String room) {
		this.room = room;
	}
	
	public String getReservePlan() {
		return reservePlan;
	}

	public void setReservePlan(String reservePlan) {
		this.reservePlan = reservePlan;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Integer getReserveSource() {
		return reserveSource;
	}

	public void setReserveSource(Integer reserveSource) {
		this.reserveSource = reserveSource;
	}
}