package com.yeejoin.amos.fas.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


@Data
@TableName("c_plan_report")
public class PlanReport extends BaseEntity {

    @TableField("batch_no")
    private String batchNo;

    @TableField("report_url")
    private String reportUrl;

    @TableField("title")
    private String title;

    @TableField(value = "drill_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date drillDate;

    @TableField("address")
    private String address;

    @TableField("compere")
    private String compere;

    @TableField("attend_person")
    private String attendPerson;

    @TableField("drill_topic")
    private String drillTopic;

    @TableField("handle_process")
    private String handleProcess;

    @TableField("drill_summary")
    private String drillSummary;

    @TableField("examine_result")
    private String examineResult;

    @TableField("biz_org_name")
    private String bizOrgName;

    @TableField("biz_org_code")
    private String bizOrgCode;

    @TableField("drill_type")
    private String drillType;

    @TableField("drill_equip")
    private String drillEquip;

    @TableField("drill_equip_id")
    private String drillEquipId;

    @TableField(exist = false)
    private Integer pageNumber;

    @TableField(exist = false)
    private Integer pageSize;

    @TableField(exist = false)
    private String startDate;

    @TableField(exist = false)
    private String endDate;

    @TableField(exist = false)
    private String equipName;
}
