package com.yeejoin.amos.fas.business.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.robot.BadRequest;
import com.yeejoin.amos.fas.business.dao.mapper.PlanReportMapper;
import com.yeejoin.amos.fas.business.dao.repository.IPlanOperationRecordDao;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import com.yeejoin.amos.fas.business.service.intfc.IPlanReportService;
import com.yeejoin.amos.fas.business.util.MyByteArrayMultipartFile;
import com.yeejoin.amos.fas.business.util.StringUtil;
import com.yeejoin.amos.fas.business.util.WordTemplateUtils;
import com.yeejoin.amos.fas.common.enums.WordTemplateTypeEum;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.PlanOperationRecord;
import com.yeejoin.amos.fas.dao.entity.PlanReport;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class PlanReportServiceImpl extends ServiceImpl<PlanReportMapper, PlanReport> implements IPlanReportService {

    private static String firstContent = "";

    @Autowired
    PlanReportMapper planReportMapper;

    @Autowired
    private IPlanOperationRecordDao planOperationRecordDao;

    @Autowired
    private IContingencyInstance iContingencyInstance;

    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, String id) {
        PlanReport report = planReportMapper.getById(Long.valueOf(id));
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        Map<String, Object> map = getWordMap(report);
        try {
            instance.exportMillCertificateWord(request, response, map, (String) map.get("document_name"),
                    WordTemplateTypeEum.StationDrilReport.getTemplateFile());
        } catch (IOException e) {
            throw new BadRequest("下载应急演练报告失败!");
        }
    }

    @Override
    public String preview(PlanReport report) {
        Map<String, Object> map = getWordMap(report);
        SimpleDateFormat dateStat = new SimpleDateFormat("yyyy年MM月dd日");
        String documentNameTime = dateStat.format(new Date());
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        String urlString = "";
        File filepdf = null;
        try {
            filepdf = instance.getWordFileItem(map, "应急演练报告" + documentNameTime, WordTemplateTypeEum.StationDrilReport.getTemplateFile(), "pdf");
            filepdf.getAbsolutePath();
            MultipartFile multipartFile = new MyByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(filepdf));
            FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFile(multipartFile);
            if (result != null) {
                Iterator<String> it = result.getResult().keySet().iterator();
                while (it.hasNext()) {
                    urlString = it.next();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (filepdf != null) {
                filepdf.delete();
            }
        }
        return urlString;
    }

    @Override
    public void createReport(String batchNo) {
        Assert.notNull(batchNo, "batchNo 不能为空！");
        PlanReport report = planReportMapper.getByBatchNo(batchNo);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        List<ContingencyPlanInstance> list = null;
        try {
            list = iContingencyInstance.queryForExecuteInfo(batchNo);
            firstContent = list.get(0).getContent();
            list.remove(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            list.forEach(instance -> {
                if ("MESSAGE".equalsIgnoreCase(instance.getRecordType())){
                    builder.append(sdf.format(instance.getCreateDate())).append(" ").append(instance.getStartUserName())
                            .append("：").append(instance.getContent()).append("\n");
                } else {
                    builder.append(sdf.format(instance.getUpdateDate())).append(" ").append(instance.getStartUserName())
                            .append("：").append(instance.getCategory()).append("\n");
                }
            });
            String str = builder.toString();
            str = str.substring(0, str.length() - 1);
            report.setHandleProcess(str);
        }
        String url = preview(report);
        report.setReportUrl(url);
        planReportMapper.updateReportById(report);
    }

    @Override
    public PlanReport updateReport(PlanReport report) {
        String url = preview(report);
        report.setReportUrl(url);
        planReportMapper.updateReportById(report);
        return report;
    }

    @Override
    public Page<PlanReport> getByPage(PlanReport planReport) {
        Page<PlanReport> objectPage = new Page<>(planReport.getPageNumber(), planReport.getPageSize());
        planReport.setPageNumber((planReport.getPageNumber() - 1) * planReport.getPageSize());
        Integer count = this.baseMapper.getByCount(planReport);
        if (count > 0) {
            objectPage.setRecords(this.baseMapper.getByPage(planReport));
            objectPage.setTotal(count);
        }
        return objectPage;
    }

    private Map<String, Object> getWordMap(PlanReport report) {
        Map<String, Object> map = new HashMap<String, Object>();
        PlanOperationRecord operationRecord = planOperationRecordDao.findByBatchNo(report.getBatchNo());
        SimpleDateFormat dateStat = new SimpleDateFormat("HH:mm");
        SimpleDateFormat drillDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        // 活动主题
        map.put("drill_title", report.getTitle());
        // 演练时间
        map.put("drill_date", ObjectUtils.isEmpty(report.getDrillDate()) ? "" : drillDateFormat.format(report.getDrillDate()));
        // 主持人
        map.put("compere", report.getCompere());
        // 演练地点
        map.put("drill_address", report.getAddress());
        // 参与人员
        map.put("attend_person", report.getAttendPerson());
        // 演习题目
        map.put("drill_topic", report.getDrillTopic());
        // 处理过程
        map.put("handle_process", StringUtil.isNotEmpty(report.getHandleProcess()) ? report.getHandleProcess()
                .replaceAll("\n", "<w:br/>") : "");
        // 预案开始时间
        map.put("start_time", dateStat.format(operationRecord.getStartTime()));
        map.put("first_content", firstContent);
        // 预案结束时间
        map.put("end_time", dateStat.format(operationRecord.getEndTime()));
        // 演习总结
        map.put("drill_summary", report.getDrillSummary());
        // 审核
        map.put("examine_result", report.getExamineResult());
        return map;
    }

    public static byte[] file2byte(File file) {
        try (FileInputStream in = new FileInputStream(file);) {
            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
