package com.yeejoin.amos.fas.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface ContingencyPlanInstanceMapper extends BaseMapper<ContingencyPlanInstance> {


    List<ContingencyPlanInstance> getPlanInstanceListByPage(@Param("batchNo") String batchNo, @Param("pageNum") Integer pageNum, @Param("size") Integer size);

    Integer getPlanInstanceCount(@Param("batchNo") String batchNo);

    Map<String, String> getUserByUserId(@Param("userId") String userId);

    /**
     * 修改动作执行状态
     *
     * @param id
     * @param runStatus
     * @return
     */
    Boolean updateStatusById(@Param("id") String id, @Param("content") String content, Boolean runStatus);

    ContingencyPlanInstance  getMessageById(@Param("id") String id);

    /**
     * 信息更新
     * @param contingencyPlanInstance
     * @return
     */
    Boolean updateMessageById(@Param("dto") ContingencyPlanInstance contingencyPlanInstance);

    String getBizOrgCode(@Param("amosOrgCode") String amosOrgCode);


    List<Map<String, Object>> getWaterInfo(@Param("current") Integer current, @Param("size") Integer size, @Param("bizOrgCode") String bizOrgCode);

    long countWater(@Param("bizOrgCode") String bizOrgCode);

    Integer getPlanInstanceCountByCondition(@Param("category") String category, @Param("recordType") String recordType, @Param("batchNo") String batchNo, @Param("content") String content);

    String getInstanceIdByBatchNOAndCategory(@Param("recordType") String recordType, @Param("category") String category, @Param("batchNo") String batchNo);

    Boolean updateTaskStatusById(@Param("id") String id, @Param("content") String content, Boolean runStatus, @Param("userName") String userName, @Param("userId") String userId, @Param("personImg") String personImg, @Param("fileType") String fileType, @Param("roleNames") String roleNames);
}
