package com.yeejoin.amos.fas.business.service.intfc;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanParamVo;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanResponseVo;
import com.yeejoin.amos.fas.business.vo.PlanDetailVo;
import com.yeejoin.amos.fas.business.vo.Toke;
import com.yeejoin.amos.fas.dao.entity.PlanDetail;
import com.yeejoin.amos.fas.exception.YeeException;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wjk
 * @date 2021-01-14
 * 预案操作
 */
public interface IContingencyPlanService {

    String DELETE_SYNC_PLAN_DOC = "DELETE_SYNC_PLAN_DOC";
    String DELETE_SYNC_PLAN_RULE = "DELETE_SYNC_PLAN_RULE";
    String DELETE_SYNC_PLAN_EQUIP = "DELETE_SYNC_PLAN_EQUIP";

    ContingencyPlanResponseVo   planStart(ContingencyPlanParamVo vo, Toke toke);

    ContingencyPlanParamVo equipmentScene(Long equipmentId,String riskType );

    Page recordListByPage ( int current, int pageSize,String planName);
    /**
     * 创建
     * @param planDetail
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    PlanDetailVo createPlan(PlanDetailVo planDetail);

    /**
     * 编辑
     * @param planDetail
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    PlanDetailVo editPlan(PlanDetailVo planDetail);

    /**
     * 单个详情
     * @param id
     * @return
     */
    PlanDetailVo detail(Long id);

    /**
     * 启用
     * @param idList
     * @return
     */
    List<PlanDetail> activatePlan(List<Long> idList);

    /**
     * 停用
     * @param idList
     * @return
     */
    List<PlanDetail> deactivatePlan(List<Long> idList);

    /**
     * 删除
     * @param idList
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    Boolean delete(List<Long> idList);

    /**
     * 分页查询
     * @param page 分页
     * @param planName 预案名称
     * @param classifyId 预案类型
     * @param planRange 适用范围
     * @param editOrgName 编写部门
     * @param implementationTimeLeft 实施时间左界限
     * @param implementationTimeRight 实施时间右界限
     * @return Page
     */
    Page<PlanDetailVo> pageFilter(Page page, String planName, Long[] classifyId, String[] planRange, String editOrgName, Date implementationTimeLeft, Date implementationTimeRight);

    /**
     * 查询预案使用的文档ID
     * @return
     */
    Map<Long, Long> getPlanUsedDocs();

    /**
     * 查询预案使用的规则ID
     * @return
     */
    Map<String, Long> getPlanUsedRules();

    /**
     * 查询预案使用的装备ID
     * @return
     */
    Map<Long, Long> getPlanUsedEquipments();

    /**
     * 监听文档取消发布/规则、装备删除动态
     */
    void subscribeTopic();

    Map<String, Object> firstGetRecord(String batchNo);

    List<HashMap<String,Object>> getRecordList(String batchNo);
}
