package com.yeejoin.amos.fas.business.controller;


import com.yeejoin.amos.fas.business.util.JSONUtil;
import com.yeejoin.amos.fas.business.util.SSLClient;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;


@RestController
@RequestMapping("/api/sso")
@Api(tags = "获取isdp的tokenAPI")
public class SsoTokenController {

    @Value("${sso.client.id}")
    private String clientId;

    @Value("${sso.client.secret}")
    private String clientSecret;

    @Value("${sso.login.client}")
    private String loginClient;

    @Value("${sso.client.url}")
    private String clientUrl;

    @Value("${sso.login.type}")
    private String loginType;

    @Autowired
    private SSLClient sslClient;

    /**
     * 获取tokenAPI
     */
    @ApiOperation(value = "获取token", notes = "获取token")
    @GetMapping(value = "/getSsoToken", produces = "application/json;charset=UTF-8")
    public ResponseModel getSsoToken(@RequestParam(value = "username") String username) {
        Map<String, Object> params = new HashMap<>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("loginClient", loginClient);
        params.put("login_type", loginType);
        params.put("username", username);
        String message = JSONUtil.toJson(params);
        String result = sslClient.doPost(clientUrl, message, "utf-8");
        return CommonResponseUtil2.success(result);
    }
}
