package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the fire_car database table.
 * 
 */
@Entity
@Table(name="f_fire_car")
@NamedQuery(name="FireCar.findAll", query="SELECT f FROM FireCar f")
public class FireCar extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	@Column(name="car_num")
	private String carNum;

	private String country;

	@Column(name="create_by")
	private String createBy;

	@Column(name="engine_num")
	private String engineNum;

	private String model;

	private String name;

	@Column(name="org_code")
	private String orgCode;

	@Column(name="dept_id")
	private String deptId;

	@Lob
	@Column(name="performance_index")
	private String performanceIndex;

	private String remark;

	private String state;

	private String type;
	
	/**
	 * 所属风险区域id
	 */
	@Column(name="risk_source_id")
	private Long riskSourceId;
	
	/**
	 * 3维坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;	
	
	/**
	 * 是否室内
	 */
	@Column(name="is_indoor")
	private Boolean isIndoor=true;

	/**
	 * 消防车图片路径
	 */
	@Column(name="photo_path")
	private String photoPath;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	public FireCar() {
	}

	public String getCarNum() {
		return this.carNum;
	}

	public void setCarNum(String carNum) {
		this.carNum = carNum;
	}

	public String getCountry() {
		return this.country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getEngineNum() {
		return this.engineNum;
	}

	public void setEngineNum(String engineNum) {
		this.engineNum = engineNum;
	}

	public String getModel() {
		return this.model;
	}

	public void setModel(String model) {
		this.model = model;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPerformanceIndex() {
		return this.performanceIndex;
	}

	public void setPerformanceIndex(String performanceIndex) {
		this.performanceIndex = performanceIndex;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getState() {
		return this.state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}
	

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}


	public String getPhotoPath() {
		return photoPath;
	}

	public void setPhotoPath(String photoPath) {
		this.photoPath = photoPath;
	}

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}
}