package com.yeejoin.amos.fas.business.action;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.BubbleTipResult;
import com.yeejoin.amos.fas.business.action.result.message.ActionResultMessage;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;

/**
 * 
 * <pre>
 * 气泡提示动作
 * </pre>
 *
 * @author amos
 * @version $Id: BubbleTipAction.java, v 0.1 2019年5月16日 上午10:42:32 amos Exp $
 */
@Component
public class BubbleTipAction implements CustomerAction
{
	private static String PACKAGEURL = "com.yeejoin.amos.fas.business.action.result.message.";
	
	//@ExposeAction("气泡提示")
	public void sendBubbleTip(Object bizobj, Boolean showInfo, Object title, String type)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//是否显示气泡
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("showInfo", showInfo);
		result.add(tempmap2);
		//显示title提示
		Map<String, Object> tempmap3 = new HashMap<>();
		tempmap3.put("title", title);
		result.add(tempmap3);
		//节点类型
		Map<String, Object> tempmap4 = new HashMap<>();
		tempmap4.put("type", type);
		result.add(tempmap4);
		
		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			ActionResultMessage<?> action = (ActionResultMessage<?>) constructor.newInstance(result);
			String firstStr = "fromws";
			String secondStr = "map";
			String thirdStr = "bubble";
			Object obj = action.execute(firstStr, secondStr, thirdStr);
			result.setToipResponse((ToipResponse) obj);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
}
