package com.yeejoin.amos.fas.business.action.result.message;

import java.io.IOException;

import com.yeejoin.amos.fas.business.action.result.AbstractActionResult;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.websocket.RuleWebSocket;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.util.Constants;
import com.yeejoin.amos.fas.core.util.CommonResponse;


public abstract class AbstractActionResultMessage<R extends ToipResponse>
		implements ActionResultMessage<ToipResponse>
{
	protected ActionResult actionResult;

	@Override
	public ToipResponse execute(String firstStr, String secondStr,
			String thirdStr) throws IOException, Exception
	{
		ToipResponse response = buildResponse(firstStr, secondStr, thirdStr,
				getActionResultByDataFormat() == null ? actionResult.getData(): getActionResultByDataFormat(),
				actionResult);
		if (!actionResult.getData().isEmpty())
		{
			sendResponse(response);
		}
		return response;
	}

	protected abstract Object getActionResultByDataFormat();

	/**
	 * 
	 * <pre>
	 * 构建对象
	 * </pre>
	 *
	 * @param viewTemp
	 * @param obj
	 * @return
	 */
	public ToipResponse buildResponse(String firstIfDomain,
			String secondIfDomain, String thirdIfDomain, Object obj,
			ActionResult actionResult)
	{
		ToipResponse toipResponse = new ToipResponse();
		toipResponse.setIFDomain(firstIfDomain);
		toipResponse.setTemplate(secondIfDomain + "_" + thirdIfDomain);
		toipResponse.setGroup("");// group值暂填充至temolate中
//		toipResponse.setActionId(ruleAction.getId());
//		toipResponse.setBizId(
//				((AbstractActionResult) actionResult).getBizObj().getId());
		toipResponse
				.setBizObj(((AbstractActionResult) actionResult).getBizObj());
		toipResponse.setResult(Constants.RESULT_SUCCESS);
		toipResponse.setDataList(obj);
		return toipResponse;
	}

	/**
	 * 
	 * <pre>
	 * 发送数据
	 * </pre>
	 *
	 * @param response
	 * @throws IOException
	 * @throws Exception
	 */
	protected void sendResponse(CommonResponse response)
			throws IOException, Exception
	{
		RuleWebSocket.sendInfo(response.toJsonStr());
		System.out.println("数据发送成功>>>>>>>>" + response.toJsonStr());
	}
}
