package com.yeejoin.amos.fas.business.controller;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.vo.Toke;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2020/5/27 15:26
 */
@RestController
@RequestMapping("/api/login")
@Api("免密登录api")
public class AvoidLoginController extends BaseController{

    @Value("${oauth2.accessToken}")
    private String checkAccessToken;

    @Value("${oauth2.password}")
    private String password;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @ApiOperation(httpMethod = "GET",value = "免密登录获取token", notes = "免密登录获取token")
    @RequestMapping(value = "/avoid/{loginId}/{accessToken}/{expireTime}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse avoidLogin(@PathVariable String loginId, @PathVariable String accessToken, @PathVariable Integer expireTime) {
        if (accessToken.equals(checkAccessToken)){
            Toke toke = remoteSecurityService.avoidLogin(loginId, password, expireTime);
            return CommonResponseUtil.success(toke);
        }
        return CommonResponseUtil.failure("令牌不正确");
    }
}
