package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IDataRefreshService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author suhg
 */
@RestController
@RequestMapping("/api/data")
@Api(tags = "三维屏数据刷新api")
public class DataRefreshController {
    @Autowired
    private IDataRefreshService dataRefreshService;
    /**
     * 全景监控执行数据刷新
     * @return success
     */
    @ApiOperation(value = "全景监控执行数据刷新",notes = "check-巡检记录,planTask-执行数据")
    @GetMapping(value = "refresh/{dataType}")
    public CommonResponse checkDataRefresh(@PathVariable String dataType){
        dataRefreshService.refreshViewData(dataType);
        return CommonResponseUtil.success();
    }

}
