package com.yeejoin.amos.fas.business.controller;

import com.google.common.collect.Maps;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipPointMapper;
import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentPointEntity;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipPontService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.FireEquipmentPoint;

//import com.yeejoin.amos.security.authorization.Authorization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/firequment/point")
@Api(tags = "消防设备风险点")
public class FireEquimtPointController extends BaseController {


    @Autowired
    private IFireEquipPontService fireEquipPontService;
    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @ApiOperation(httpMethod = "POST", value = "添加风险点", notes = "添加风险点")
    @RequestMapping(value = "", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse createPoint(@RequestBody FireEquipmentPoint fireEquipmentPoint) throws Exception {

        if (fireEquipmentPoint == null
                || StringUtils.isEmpty(fireEquipmentPoint.getName())
                || StringUtils.isEmpty(fireEquipmentPoint.getType())
                || StringUtils.isEmpty(fireEquipmentPoint.getCode())){
        	return CommonResponseUtil.failure("请检查必填字段");
        };
        ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
		fireEquipmentPoint.setOrgCode(compCode);
        fireEquipmentPoint.setCreateBy(getUserId());
        fireEquipmentPoint.setCreateDate(new Date());
        
        
        //根据编号查询监测点
        FireEquipmentPointEntity pointEntity = fireEquipPointMapper.getByCode(fireEquipmentPoint.getCode());
        if (pointEntity != null) {
            return CommonResponseUtil.failure("监测点编号已经存在");
        }
        
        return CommonResponseUtil.success(fireEquipPontService.savePoint(fireEquipmentPoint));
    }


   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT", value = "编辑风险点", notes = "编辑风险点")
    @RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse udpatePoint(@PathVariable Long id, @RequestBody FireEquipmentPoint fireEquipmentPoint) {
        fireEquipmentPoint.setId(id);
        return CommonResponseUtil.success(fireEquipPontService.savePoint(fireEquipmentPoint));
    }


    @ApiOperation(httpMethod = "GET", value = "查询单个风险单", notes = "查询单个风险单")
    @RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryPoint(@PathVariable Long id) {

        return CommonResponseUtil.success(fireEquipPontService.queryOne(id));
    }


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "DELETE", value = "删除风险点", notes = "查询单个风险单")
    @RequestMapping(value = "/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
    public CommonResponse deletePoint(@PathVariable String ids) throws Exception {
        String[] idArray = ids.split(",");
        return CommonResponseUtil.success(fireEquipPontService.deletePoint(idArray));
    }

    @ApiOperation(httpMethod = "GET", value = "指定消防设备的风险点列表", notes = "指定消防设备的风险点列表")
    @RequestMapping(value = "/fireequipment/{fireEqumtId}/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse pointList(@PathVariable Long fireEqumtId,
                                    @RequestParam(required = false) String name,
                                    @RequestParam int pageNumber,
                                    @RequestParam int pageSize
    ) {
        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        return CommonResponseUtil.success(fireEquipPontService.queryByFireEquimt(fireEqumtId, name, commonPageable));
    }

    @ApiOperation(value = "指定消防设备的风险点列表", notes = "指定消防设备的风险点列表")
    @GetMapping(value = "/page")
    public CommonResponse page(@ApiParam(value = "起始记录", required = true) @RequestParam Integer pageNumber,
                               @ApiParam(value = "每页条数", required = true) @RequestParam Integer pageSize,
                               @ApiParam(value = "是否绑定设备（0：否；1：是）") @RequestParam(required = false) Integer isBindDevice,
                               @ApiParam(value = "监测点编号或者监测点名称模糊匹配") @RequestParam(required = false) String searchValue,
                               @ApiParam(value = "类型（模拟量：ANALOGUE；开关量：SWITCH）") @RequestParam(required = false) String type) {
        Map<String, Object> queryMap = Maps.newHashMap();
        ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
        queryMap.put("pageNumber", pageNumber);
        queryMap.put("pageSize", pageSize);
        if (isBindDevice != null && isBindDevice == 0) {
            queryMap.put("fireEquipmentId", 0);
        }
        queryMap.put("searchValue", searchValue);
        queryMap.put("type", type);
        queryMap.put("compCode", compCode);
        return fireEquipPontService.queryByMap(queryMap);
    }

    @ApiOperation(value = "批量绑定", notes = "批量绑定")
    @GetMapping(value = "/batch/bindToEquipment")
    public CommonResponse batchBindToEquipment(@ApiParam(value = "设备编号", required = true) @RequestParam Long deviceId,
                                               @ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
        if (StringUtils.isEmpty(pointIds)) {
            return CommonResponseUtil.failure("监测点编号必填");
        }
        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return fireEquipPontService.batchBindToEquipment(deviceId, ids);
    }

    @ApiOperation(value = "批量解绑", notes = "批量解绑")
    @GetMapping(value = "/batch/unbindToEquipment")
    public CommonResponse batchUnbindToEquipment(@ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
        if (StringUtils.isEmpty(pointIds)) {
            return CommonResponseUtil.failure("监测点编号必填");
        }
        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return fireEquipPontService.batchUnbindToEquipment(ids);
    }

    @ApiOperation(value = "添加监测点", notes = "添加监测点")
    @PostMapping(value = "/save")
    public CommonResponse save(@ApiParam(value = "监测点对象", required = true) @RequestBody FireEquipmentPointEntity fireEquipmentPointEntity) {
        if (fireEquipmentPointEntity.getFireEquipmentId() == null) {
            fireEquipmentPointEntity.setFireEquipmentId(0L);
        }
        
       
        
        
        return fireEquipPontService.save(fireEquipmentPointEntity);
    }

    @ApiOperation(value = "修改监测点", notes = "修改监测点")
    @PostMapping(value = "/update")
    public CommonResponse update(@ApiParam(value = "监测点对象", required = true) @RequestBody FireEquipmentPointEntity fireEquipmentPointEntity) {
        return fireEquipPontService.update(fireEquipmentPointEntity);
    }

    @ApiOperation(value = "批量删除监测点", notes = "批量删除监测点")
    @GetMapping(value = "/batch/delete")
    public CommonResponse batchDelete(@ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
        if (StringUtils.isEmpty(pointIds)) {
            return CommonResponseUtil.failure("监测点编号必填");
        }
        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return fireEquipPontService.batchDelete(ids);
    }

    @ApiOperation(value = "根据设备类型查询设备", notes = "批量删除监测点")
    @GetMapping(value = "/listByType")
    public CommonResponse listByType(@ApiParam(value = "装备分类：0-设备类；1-耗材类;2-视频监控;3-灭火器材") @RequestParam(required = false) Integer equipClassify) {
        return fireEquipPontService.listByType(equipClassify);
    }


}
