package com.yeejoin.amos.fas.business.controller;


import com.yeejoin.amos.fas.business.service.impl.ContingencyInstanceImpl;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyOriginalDataService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.xml.bind.ValidationEvent;
import java.util.*;

@RestController
@RequestMapping(value = "/api/timeline")
@Api(tags="时间轴")
public class TimeLineController extends BaseController{

    private static final Logger log = LoggerFactory.getLogger(TimeLineController.class);
    @Autowired
    IContingencyInstance iContingencyInstance;

    @Autowired
    IContingencyOriginalDataService iContingencyOriginalDataService;

    static LinkedList<Map<String,String >> fireQueue  = new LinkedList<>();


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET",value = "根据批次号查询时间轴", notes = "根据批次号查询时间轴")
    @RequestMapping(value = "/{instanceNo}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryPoint(@PathVariable String  instanceNo,@RequestParam("recordType") String recordType) throws Exception{

        return CommonResponseUtil.success(iContingencyInstance.queryForTimeLine(instanceNo,recordType));
    }


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT",value = "点击按钮", notes = "点击按钮")
    @RequestMapping(value = "/fire", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse fire(@RequestParam("batchNo") String  batchNo,
                                     @RequestParam("stepCode") String stepCode,
                                     @RequestParam("buttonCode") String buttonCode,
                                     @RequestParam("confirm") String confirm,
                                     @RequestParam("contingencyPlanId") String contingencyPlanId,
                                     @RequestParam("stepState") String stepState) throws Exception{


        Map<String,String> map = new HashMap<>();
        map.put("batchNo",batchNo);
        map.put("stepCode",stepCode);
        map.put("buttonCode",buttonCode);
        map.put("confirm",confirm);
        map.put("contingencyPlanId",contingencyPlanId);
        map.put("stepState",stepState);
        fireQueue.addLast(map);

        return CommonResponseUtil.success("SUCCESS");
    }


    @Scheduled(cron = "*/2 * * * * ?")
    private void runFireQueue()  throws Exception
    {

        if(fireQueue.size() == 0)
            return;

        Map<String,String>  map = fireQueue.getFirst();

        String batchNo = map.get("batchNo");
        String stepCode = map.get("stepCode");
        String buttonCode = map.get("buttonCode");
        String confirm = map.get("confirm");
        String contingencyPlanId = map.get("contingencyPlanId");
        String  stepState = map.get("stepState");
        try
        {
            log.info("fireQueue-size:"+fireQueue.size());
            log.info("stepCode:" + map.get("stepCode"));
            log.info("buttonCode:" + map.get("buttonCode"));
            log.info("confirm:" + map.get("confirm"));
            log.info("stepState:" + map.get("stepState"));

            iContingencyInstance.setButtonExecuted(batchNo,contingencyPlanId,buttonCode,confirm);
            iContingencyInstance.fire(batchNo,stepCode,contingencyPlanId,buttonCode,confirm,stepState);
        }catch (Exception e)
        {
            //iContingencyInstance.setButtonWait(batchNo,contingencyPlanId,confirm);
            throw  e;
        }finally {
            fireQueue.removeFirst();
        }
    }









   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "POST",value = "查询预案记录", notes = "查询预案记录")
    @RequestMapping(value = "/contingency/page", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse contingencyRecord(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable
    ) {
        //CommonPageable commonPageable = new CommonPageable(pageNumber,pageSize);

        String  contingencyName = null;
        String  equipmentId = null;
        String  createTime = null;
        if(!CollectionUtils.isEmpty(queryRequests))
        {
            for(CommonRequest request:queryRequests)
            {
                if("contingencyName".equals(request.getName()))
                {
                    contingencyName = String.valueOf(request.getValue());
                }
                if("equipmentId".equals(request.getName()))
                {
                    equipmentId = String.valueOf(request.getValue());
                }
                if("createTime".equals(request.getName()))
                {
                    createTime = String.valueOf(request.getValue());
                }
            }
        }

        return CommonResponseUtil.success(iContingencyOriginalDataService.queryForPage(contingencyName,equipmentId,createTime,commonPageable));
    }











    String operate = "{" +
            "    \"type\": \"button\"," +
            "    \"operate\": [" +
            "        {" +
            "            \"title\": \"确认着火\"," +
            "            \"paramName\": \"batchNo\"," +
            "            \"paramValue\": \"11\"," +
            "            \"requestUrl\": \"url\"," +
            "            \"icon\": \"querenzhuohuo\"," +
            "            \"confirm\": true," +
            "            \"state\": \"executed\"" +
            "        }," +
            "        {" +
            "            \"title\": \"消除误报\"," +
            "            \"paramName\": \"batchNo\"," +
            "            \"paramValue\": \"11\"," +
            "            \"requestUrl\": \"url\"," +
            "            \"icon\": \"xiaochuwubao\"," +
            "            \"confirm\": true," +
            "            \"state\": \"wait\"" +
            "        }" +
            "    ]" +
            "}";

}
