package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentEntity;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.param.FireEquipmentParam;
import com.yeejoin.amos.fas.business.vo.EquipCommunicationData;
import com.yeejoin.amos.fas.core.common.response.EquipDetailsResponse;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FireEquipMapper extends BaseMapper {

    long countPageData(CommonPageInfoParam param);

    List<HashMap<String, Object>> getFireEquipPage(CommonPageInfoParam param);

    long countFireEquipByEquipIdPageData(CommonPageInfoParam param);

    List<HashMap<String, Object>> getFFireEquipByEquipIdPage(CommonPageInfoParam param);


    long queryForFireEquipmentHistoryCount(@Param("fireEquipmentName") String fireEquipmentName,
                                           @Param("equipmentName") String equipmentName,
                                           @Param("startTime") String startTime,
                                           @Param("endTime") String endTime);

    //查询 消防设备历史数据
    List<Map> queryForFireEquipmentHistory(
            @Param("fireEquipmentName") String fireEquipmentName,
            @Param("equipmentName") String equipmentName,
            @Param("startTime") String startTime,
            @Param("endTime") String endTime,
            @Param("start") long start,
            @Param("length") int length
    );


    long queryForEquipmentPageCount(@Param("name") String name,
                                    @Param("code") String code,
                                    @Param("equipClassify") String equipClassify);

    List<Map> queryForEquipmentPage(
            @Param("name") String name,
            @Param("code") String code,
            @Param("equipClassify") String equipClassify,
            @Param("start") long start,
            @Param("length") int length);


    List<Map> queryForGroupCount(@Param("fireStationId") Long fireStationId);

    EquipDetailsResponse findEquipDetailsById(@Param("id") Long id);

    List<EquipCommunicationData> findAllEquipPointInfo();

    EquipCommunicationData findOneByPointCode(@Param("code") String code);

    void saveBatch(List<FireEquipmentParam> list);

    void updateBatch(List<FireEquipmentParam> list);

    List<FireEquipmentEntity> listByCodes(@Param("codes") Set<String> codes);

    List<FireEquipmentEntity> listByType(@Param("type") Integer type);

    List<Map> queryEquimentRelation(
            @Param("start")long start,
            @Param("length")int length,
            @Param("equipmentId") String equipmentId,
            @Param("fname") String fname);

    Long queryEquimentRelationCount(
            @Param("equipmentId") String equipmentId,
            @Param("fname") String fname);

    FireEquipmentEntity findById(@Param("id") Long id);
}
