package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

/**
 * <pre>
 *
 * </pre>
 *
 * @author HK
 * @version $Id: IMessageRepository.java, v 0.1 2018年1月18日 下午7:52:13 HK Exp $
 */
@Repository
public interface IContingencyPlanInstanceRepository extends BaseDao<ContingencyPlanInstance, String> {
    int countByBatchNo(String batchNo);


    @Query(value = "SELECT " +
            " *" +
            " FROM " +
            " contingency_plan_instance t" +
            " WHERE" +
            " t.batch_no = ?" +
            " AND t.record_type = ?" +
            " ORDER BY" +
            " t.sort DESC", nativeQuery = true)
    List<ContingencyPlanInstance> queryForCategory(String batch_no,String recordType);

    @Query(value =
            "select distinct sub_category " +
            " from contingency_plan_instance t " +
            " where t.batch_no = ?1 " +
            " and t.category=?2 " +
            " order by t.sort desc", nativeQuery = true)
    List<String> queryForSubCategory(String batch_no, String category);

    @Query(value =
            "select * " +
                    "from contingency_plan_instance t " +
                    " where t.batch_no = ?1 and  t.category=?2 and t.sub_category=?3" +
                    " order by t.sort desc ", nativeQuery = true)
    List<ContingencyPlanInstance> queryForContent(String batch_no,String category,String subCategory);
    
    Optional<ContingencyPlanInstance> findById(String id);
}
