package com.yeejoin.amos.fas.business.param;

import cn.afterturn.easypoi.excel.annotation.Excel;

public class WaterResourceParam {

    private Long id;

    @Excel(name = "编号", width = 20)
    private String code;

    @Excel(name = "名称", orderNum = "1", width = 20)
    private String name;

    @Excel(name = "类型", replace = {"消火栓_1", "消防水池_2", "喷淋_3"}, orderNum = "3")
    private String type;

    @Excel(name = "三维坐标", orderNum = "4", width = 15)
    private String position3d;

    @Excel(name = "三维楼层", orderNum = "5")
    private String floor3d;

    @Excel(name = "是否室内", replace = {"是_1", "否_0"}, orderNum = "6")
    private Boolean isIndoor=true;

    @Excel(name = "所属风险区域", orderNum = "7")
    private Long riskSourceId;

    @Excel(name = "房间", orderNum = "8")
    private String room;

    @Excel(name = "位置", orderNum = "9")
    private String address;

    @Excel(name = "机构编号", orderNum = "10")
    private String orgCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPosition3d() {
        return position3d;
    }

    public void setPosition3d(String position3d) {
        this.position3d = position3d;
    }

    public String getFloor3d() {
        return floor3d;
    }

    public void setFloor3d(String floor3d) {
        this.floor3d = floor3d;
    }

    public Boolean getIsIndoor() {
        return isIndoor;
    }

    public void setIsIndoor(Boolean isIndoor) {
        this.isIndoor = isIndoor;
    }

    public Long getRiskSourceId() {
        return riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public String getRoom() {
        return room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
