
package com.yeejoin.amos.fas.business.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.google.common.base.Joiner;
import com.yeejoin.amos.fas.business.dao.mapper.AccidentTypeMapper;
import com.yeejoin.amos.fas.business.dao.repository.IAccidentTypeDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskFactorDao;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IAccidentTypeService;
import com.yeejoin.amos.fas.dao.entity.AccidentType;
import com.yeejoin.amos.fas.dao.entity.RiskFactor;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.util.CollectionUtils;

@Service("accidentTypeService")
public class AccidentTypeServiceImpl implements IAccidentTypeService {

	@Autowired
	AccidentTypeMapper accidentTypeMapper;
	@Autowired
	IAccidentTypeDao  iAccidentTypeDao;
	@Autowired
	IRiskFactorDao iRiskFactorDao;
	@Autowired
	private RemoteSecurityService remoteSecurityService;
	@Override
	public void detAccidentType(Long[] param) {
		//1.校验
		for(Long id : param){
			checkBeforeDet(id);
		}
		//2.删除
		iAccidentTypeDao.deleteAllByIds(param);
	}
	
/**
 * 关联数据校验
 * @param id
 */
	private void checkBeforeDet(Long id) {
		List<RiskFactor> list = iRiskFactorDao.findByAccidentTypeId(id);
		if(null != list && list.size()>0){
			throw new YeeException("危险因素"+list.get(0).getName()+"在使用中，不能删除");
		}
	}

	@Override
	public void editAccidentType(HashMap<String, Object> map) {
		AccidentType param = (AccidentType)map.get("param");
		String orgCode = map.get("org_code") == null ? "":map.get("org_code").toString();
		String userId = map.get("user_id")== null ? "0":map.get("user_id").toString();
		String deptId = map.get("dept_id")== null ? "0":map.get("dept_id").toString();
		param.setOrgCode(orgCode);
		param.setDeptId(deptId);
		param.setCreateBy(userId);
		param.setCreateDate(new Date());
		iAccidentTypeDao.save(param);
	}

	@Override
	public List<HashMap<String,Object>> queryAccidentType(String orgCode) {
		return accidentTypeMapper.findAccidentTypeListByOrgCode(orgCode);
	}

	@Override
	public Page<HashMap<String, Object>> queryAccidentTypePage(String toke,String product,String appKey,CommonPageInfoParam param) {
		long total = accidentTypeMapper.countPageData(param);
		List<HashMap<String, Object>> content  = accidentTypeMapper.findAccidentTypePage(param);
		if(!CollectionUtils.isEmpty(content)){
			Set<String> userIds = new HashSet<>();
			Set<String> deptIds = new HashSet<>();
			for(HashMap<String, Object> map : content)
			{
				String userId = String.valueOf(map.get("createBy"));
				String deptId = String.valueOf(map.get("deptId"));
				userIds.add(userId);
				deptIds.add(deptId);
			}
			userIds.remove(null);
			userIds.remove("");
			deptIds.remove(null);
			deptIds.remove("");
			List<AgencyUserModel> users = new ArrayList<>();
			if(!CollectionUtils.isEmpty(userIds)){
				users = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
			}
			Map<String, String> userMap = users.stream().collect(Collectors.toMap(AgencyUserModel::getUserId,AgencyUserModel::getRealName));
			List<DepartmentModel> depts = new ArrayList<>();
			if(!CollectionUtils.isEmpty(deptIds)){
				depts = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(deptIds));
			}
			Map<String, String > deptMap = depts.stream().collect(Collectors.toMap(e-> e.getSequenceNbr().toString(),DepartmentModel::getDepartmentName));
			content.forEach(e -> {
				e.put("userName",userMap.get(e.get("createBy")));
				e.put("deptName",deptMap.get(e.get("deptId")));
			});
		}
		Page<HashMap<String, Object>> result = new PageImpl<>(content, param, total);
		return result;
	}

}
