package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.BasicEntity;
import com.yeejoin.amos.fas.dao.entity.FireEquipment;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IFireEquipService {

	Page<HashMap<String, Object>> queryFireEquip(CommonPageInfoParam param);

	Page<HashMap<String, Object>> queryFireEquipByProId(CommonPageInfoParam param);

	List<String> findFireEquipArea();

	FireEquipment save(FireEquipment fireEquipment);

	FireEquipment queryOne(Long id);

	/**
	 * 删除单个风险点
	 * @return
	 * @throws Exception
	 */
	String [] delete(String []idArray) throws Exception;

	Page queryForFireEquipmentHistory(String fireEquipmentName,
												  String equipmentName,
												  String startTime,
												  String endTime,
												  CommonPageable commonPageable);

	Page queryForEquipmentList(String name, String code,String equipClassify,CommonPageable commonPageable);

	//查询设备明细
	Object queryForDetail(String type, Long id) throws Exception;

	/**
	 *  查询关联数量
	 * @param ids
	 * @return
	 */
	int countAssociatedEquipStationByIds(String[] ids);

	Boolean isExistByCode(String code);
}
