package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.WaterResource;
import com.yeejoin.amos.fas.dao.entity.WaterResourceEquipment;

import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

public interface IWaterResourceService {

    /**
     * 保存或者更新风险点
     * @param waterResource
     * @return
     */
    WaterResource save(WaterResource waterResource);


    /**
     * 查询单个风险点
     * @param id
     * @return
     */
    Map queryOne(Long id);


    /**
     * 删除单个风险点
     * @return
     * @throws Exception
     */
    String [] delete(String[] idArray) throws Exception;


    /**
     * 查询指定设备的风险点列表
     * @return
     */
    Page queryForPage(String compCode,String username, String code, String  type,CommonPageable pageable);
    
    void saveBindFireEquipment(List<WaterResourceEquipment> waterResourceEquipments);
    
    void deleteBindFireEquipment(List<WaterResourceEquipment> waterResourceEquipments);

    /**
     * 查询已经绑定的消防设备列表
     * @param waterResourceId
     * @return
     */
    Page queryBindFireEquemtPage(Long waterResourceId,CommonPageable pageable);


	Object queryForList();

    int countAssociatedEquipWaterByIds(String[] ids);
}
