package com.yeejoin.amos.fas.business.util;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import static com.yeejoin.amos.fas.business.constants.FasConstant.*;

@Component
public class HttpUtil {

    private ObjectMapper objectMapper = new ObjectMapper();

    private static String dutyUrl;

    @Value("${DutyMode.dutyUrl}")
    public void setDutyUrl(String dutyUrl) {
        HttpUtil.dutyUrl = dutyUrl;
    }

    public static String doGet(String url) {
    	SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.TEXT_HTML);
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<String> httpEntity = new HttpEntity(httpHeaders);
        ResponseEntity<String>  response = restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class);
        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        return jsonObject.toString();
    }
    
    
    public static String PostJson(String url, String json) {
    	SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        
    	HttpHeaders headers = new HttpHeaders();
        HttpMethod method = HttpMethod.POST;
        // 以表单的方式提交
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("X-From-Service", "true");
        //将请求头部和参数合成一个请求
        HttpEntity<String> requestEntity = new HttpEntity<>(json, headers);
        //执行HTTP请求，将返回的结构使用ResultVO类格式化
        ResponseEntity<String> response = restTemplate.postForEntity(url, requestEntity, String.class);

        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        return jsonObject.toString();
    }
    
    
    public static String doPostJson(String url, String json) {
        if (ObjectUtils.isEmpty(url)){
            url = dutyUrl;
        }
    	SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        
    	HttpHeaders headers = new HttpHeaders();
        HttpMethod method = HttpMethod.POST;
        // 以表单的方式提交
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("appKey", appKey);
        headers.set("product", product);
        headers.set("token", token);
        headers.set("orgCode", staticOrgCode);
        headers.set("X-Access-Token", token);
        //将请求头部和参数合成一个请求
        HttpEntity<String> requestEntity = new HttpEntity<>(json, headers);
        //执行HTTP请求，将返回的结构使用ResultVO类格式化
        ResponseEntity<String> response = restTemplate.postForEntity(url, requestEntity, String.class);

        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        return jsonObject.toString();
    }

    public static String appendPostJson(String suffix,String json) {
        String url = dutyUrl + suffix;
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        RestTemplate restTemplate = new RestTemplate(requestFactory);

        HttpHeaders headers = new HttpHeaders();
        HttpMethod method = HttpMethod.POST;
        // 以表单的方式提交
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("appKey", appKey);
        headers.set("product", product);
        headers.set("token", token);
        headers.set("orgCode", staticOrgCode);
        headers.set("X-Access-Token", token);
        //将请求头部和参数合成一个请求
        HttpEntity<String> requestEntity = new HttpEntity<>(json, headers);
        //执行HTTP请求，将返回的结构使用ResultVO类格式化
        ResponseEntity<String> response = restTemplate.postForEntity(url, requestEntity, String.class);

        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        return jsonObject.toString();
    }
}
